/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.IUMGroupAccess;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.Quota;
import de.accxia.apps.confluence.ium.util.UserGroupException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="IUMHelperCacheService")
@ExportAsService(value={IUMHelperCacheService.class})
public class IUMHelperCacheServiceImpl
implements IUMHelperCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(IUMHelperCacheServiceImpl.class);
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final LoadingCache<String, List<String>> groupList4UserCache;
    private final LoadingCache<String, List<String>> userList4GroupCache;
    private final LoadingCache<String, IUMGroupAccess> iumProcessing4UserCache;
    public static final long DURATION = 30L;

    @Inject
    public IUMHelperCacheServiceImpl(CrowdService crowdService, UserManager userManager, GroupManager groupManager, UserAccessor userAccessor) {
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.groupList4UserCache = this.initGroupList4UserCache();
        this.userList4GroupCache = this.initUserList4GroupCache();
        this.iumProcessing4UserCache = this.initIUMProcessing4UserCache();
    }

    private LoadingCache<String, List<String>> initGroupList4UserCache() {
        CacheLoader<String, List<String>> cacheLoader = new CacheLoader<String, List<String>>(){

            @Nonnull
            public List<String> load(@Nonnull String cacheKey) {
                return IUMHelperCacheServiceImpl.this.getGroupsForUser(cacheKey);
            }
        };
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)cacheLoader);
    }

    private LoadingCache<String, List<String>> initUserList4GroupCache() {
        CacheLoader<String, List<String>> cacheLoader = new CacheLoader<String, List<String>>(){

            @Nonnull
            public List<String> load(@Nonnull String cacheKey) {
                return IUMHelperCacheServiceImpl.this.getUsersForGroup(cacheKey);
            }
        };
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)cacheLoader);
    }

    private LoadingCache<String, IUMGroupAccess> initIUMProcessing4UserCache() {
        CacheLoader<String, IUMGroupAccess> cacheLoader = new CacheLoader<String, IUMGroupAccess>(){

            @Nonnull
            public IUMGroupAccess load(@Nonnull String cacheKey) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("LoadingCache key=|" + cacheKey + "|");
                }
                IUMGroupAccess iumGroupAccess = new IUMGroupAccess();
                String groupNames = DAO.getIUMGroupsDisabled();
                if (StringUtils.isEmpty((CharSequence)groupNames)) {
                    iumGroupAccess.setGroupDisable(false);
                    iumGroupAccess.setGroupEnable(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("LoadingCache getIUMGroupsDisabled = isEmpty key= " + cacheKey + " ==> " + iumGroupAccess.isGroupEnable() + " | isGroupDisable=  " + iumGroupAccess.isGroupDisable());
                    }
                    return iumGroupAccess;
                }
                for (String groupName : groupNames.split(",")) {
                    if (!IUMHelperCacheServiceImpl.this.isUserMemberOfGroup(cacheKey, groupName)) continue;
                    iumGroupAccess.setGroupDisable(true);
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)(groupNames = DAO.getIUMGroups()))) {
                    iumGroupAccess.setGroupEnable(false);
                } else {
                    for (String groupName : groupNames.split(",")) {
                        if (!IUMHelperCacheServiceImpl.this.isUserMemberOfGroup(cacheKey, groupName)) continue;
                        iumGroupAccess.setGroupEnable(true);
                        break;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("LoadingCache key=" + cacheKey + " ==>  isGroupEnable=" + iumGroupAccess.isGroupEnable() + " | isGroupDisable=  " + iumGroupAccess.isGroupDisable());
                }
                return iumGroupAccess;
            }
        };
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)cacheLoader);
    }

    @Override
    public boolean isUserInDisableGroups(ConfluenceUser currentUser) {
        try {
            return ((IUMGroupAccess)this.iumProcessing4UserCache.get((Object)currentUser.getName())).isGroupDisable();
        }
        catch (ExecutionException e) {
            LOG.error("User [" + currentUser.getName() + "] unknown " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean freshIsUserInDisableGroups(ConfluenceUser currentUser) {
        try {
            this.iumProcessing4UserCache.refresh((Object)currentUser.getName());
            return ((IUMGroupAccess)this.iumProcessing4UserCache.get((Object)currentUser.getName())).isGroupDisable();
        }
        catch (ExecutionException e) {
            LOG.error("User [" + currentUser.getName() + "] unknown " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isUserInEnableGroups(ConfluenceUser currentUser) {
        try {
            return ((IUMGroupAccess)this.iumProcessing4UserCache.get((Object)currentUser.getName())).isGroupEnable();
        }
        catch (ExecutionException e) {
            LOG.error("User [" + currentUser.getName() + "] unknown " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean freshIsUserInEnableGroups(ConfluenceUser currentUser) {
        try {
            this.iumProcessing4UserCache.refresh((Object)currentUser.getName());
            return ((IUMGroupAccess)this.iumProcessing4UserCache.get((Object)currentUser.getName())).isGroupEnable();
        }
        catch (ExecutionException e) {
            LOG.error("User [" + currentUser.getName() + "] unknown " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> fromCacheUsersForGroup(String groupName) {
        try {
            return (List)this.userList4GroupCache.get((Object)groupName);
        }
        catch (ExecutionException e) {
            LOG.error("Group [" + groupName + "] unknown " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public IUMGroupAccess fromCacheIUMGroupAccessForUser(String userName) {
        try {
            return (IUMGroupAccess)this.iumProcessing4UserCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            LOG.error("User [" + userName + "] unknown " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> fromCacheGroupsForUser(String userName) {
        try {
            return (List)this.groupList4UserCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            LOG.error("User [" + userName + "] unknown " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int countFromCacheUsersForGroup(String groupName) {
        try {
            return ((List)this.userList4GroupCache.getUnchecked((Object)groupName)).size();
        }
        catch (Exception e) {
            LOG.error("Group [" + groupName + "] unknown " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public int countFromCacheUsersForGroupReal(String groupName) {
        try {
            return ((List)this.userList4GroupCache.get((Object)groupName)).size();
        }
        catch (Exception e) {
            LOG.error("Group [" + groupName + "] unknown " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean checkFillUsersPercentageFromCache(int percentage) {
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        if (groupEnabled == null || queueSizeTxt == null) {
            return false;
        }
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        int sumOfUsers = 0;
        int sumOfSlots = 0;
        for (int i = 0; i < groupsEnabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
            int qs = this.safeParseToInt(queueSizes[i]);
            sumOfUsers += this.fromCacheUsersForGroup(groupsEnabled[i]).size();
            sumOfSlots += qs;
        }
        return (double)sumOfUsers > (double)(sumOfSlots * percentage) / 100.0;
    }

    @Override
    public Quota checkCanGetFreeSlots(String userName) throws EntityException {
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        if (groupEnabled == null || groupDisabled == null || queueSizeTxt == null || userName == null) {
            return Quota.Empty;
        }
        String[] groupsDisabled = groupDisabled.split(",");
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
            int qs = this.safeParseToInt(queueSizes[i]);
            int queue = 0;
            if (this.isUserInGroup(userName, groupsDisabled[i]) && (queue = this.countFromCacheUsersForGroup(groupsEnabled[i])) < qs) {
                return new Quota(qs, qs - queue);
            }
            List<String> groups = this.fromCacheGroupsForUser(userName);
            boolean found = false;
            for (String grp : groups) {
                if (!grp.equals(groupsDisabled[i])) continue;
                found = true;
                break;
            }
            if (found && this.fromCacheGroupsForUser(userName).size() < qs) {
                return new Quota(qs, qs - queue);
            }
            for (String grp : groups) {
                if (!grp.equals(groupsEnabled[i])) continue;
                return new Quota(qs, 1);
            }
        }
        return Quota.Empty;
    }

    @Override
    public boolean removeUserAccessFromCache(ConfluenceUser currentUser) {
        if (currentUser != null) {
            this.iumProcessing4UserCache.invalidate((Object)currentUser.getName());
            this.groupList4UserCache.invalidate((Object)currentUser.getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUserAccessFromCache(String userName) {
        if (userName != null) {
            this.iumProcessing4UserCache.invalidate((Object)userName);
            this.groupList4UserCache.invalidate((Object)userName);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeGroupAccessFromCache(String groupName) {
        if (groupName != null) {
            this.userList4GroupCache.invalidate((Object)groupName);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIUMProcessing4UserCache() {
        this.iumProcessing4UserCache.invalidateAll();
        return true;
    }

    @Override
    public boolean removeAllCache() {
        try {
            this.iumProcessing4UserCache.invalidateAll();
            this.iumProcessing4UserCache.invalidateAll();
            this.groupList4UserCache.invalidateAll();
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> getGroupsForUser(String userName) {
        List groups = this.userAccessor.getGroupNamesForUserName(userName);
        return groups;
    }

    @Override
    public List<String> getUsersForGroup(String groupName) {
        try {
            List groups = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(groupName));
            return groups;
        }
        catch (EntityException e) {
            LOG.error("Group [" + groupName + "] unknown " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isUserMemberOfGroup(String userName, String groupName) {
        return this.crowdService.isUserMemberOfGroup(userName, groupName);
    }

    @Override
    public void addUserToGroup(String userName, String groupName) {
        User user = this.crowdService.getUser(userName);
        Group accessGroup = this.crowdService.getGroup(groupName);
        try {
            this.crowdService.addUserToGroup(user, accessGroup);
        }
        catch (Exception e) {
            LOG.error("User [" + userName + "] cannot be add from group [" + groupName + "] " + e.getMessage(), (Throwable)e);
            throw new UserGroupException("User [" + userName + "] cannot be add from group [" + groupName + "]", e);
        }
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) {
        if (this.isUserMemberOfGroup(userName, groupName)) {
            User user = this.crowdService.getUser(userName);
            Group group = this.crowdService.getGroup(groupName);
            try {
                this.crowdService.removeUserFromGroup(user, group);
            }
            catch (Exception e) {
                LOG.error("User [" + userName + "] cannot be removed from group [" + groupName + "]" + e.getMessage(), (Throwable)e);
                throw new UserGroupException("User [" + userName + "] cannot be removed from group [" + groupName + "]", e);
            }
        }
    }

    @Override
    public void omitReadOnlyAccessGroup(String accessGroupName) {
        Group group = this.crowdService.getGroup(accessGroupName);
        try {
            this.crowdService.updateGroup(group);
        }
        catch (Exception e) {
            LOG.error("Cannot check the access group read-only mode because of an unexpected exception." + e.getMessage(), (Throwable)e);
            throw new UserGroupException("Cannot check the access group read-only mode because of an unexpected exception.", e);
        }
    }

    private boolean isUserInGroup(String userName, String groupName) {
        List<String> groups = this.fromCacheGroupsForUser(userName);
        for (String grp : groups) {
            if (!grp.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private int safeParseToInt(String duration) {
        if (duration == null || duration.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(duration);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

