/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.impl.OldestUser;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.Quota;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="IUMHelperService")
@ExportAsService(value={IUMHelperService.class})
public class IUMHelperServiceImpl
implements IUMHelperService {
    private static final Logger log = LoggerFactory.getLogger(IUMHelperServiceImpl.class);
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    private IUMHelperCacheService iumHelperCacheService;
    private PocketRepository pocketRepository;
    private MembershipDao membershipDao;
    public static final boolean MOVE_USER = false;

    @Inject
    public IUMHelperServiceImpl(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, IUMHelperCacheService iumHelperCacheService, PocketRepository pocketRepository, SpacePermissionManager spacePermissionManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.spacePermissionManager = (SpacePermissionManager)Preconditions.checkNotNull((Object)spacePermissionManager);
        this.iumHelperCacheService = iumHelperCacheService;
        this.pocketRepository = pocketRepository;
        try {
            this.membershipDao = (MembershipDao)ComponentLocator.getComponent(MembershipDao.class, (String)"embeddedCrowdMembershipDao");
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String checkServices() {
        StringBuffer sb = new StringBuffer();
        try {
            MembershipDao membership = (MembershipDao)ComponentLocator.getComponent(MembershipDao.class, (String)"embeddedCrowdMembershipDao");
            sb.append(" OK " + membership.getClass());
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            Collection collections = ComponentLocator.getComponents(MembershipDao.class);
            for (MembershipDao collection : collections) {
                sb.append(" OK " + collection.getClass());
            }
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public boolean isUserInGroups(ConfluenceUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        if (currentUser != null) {
            for (String group : groups.split(",")) {
                if (!this.userManager.isUserInGroup(currentUser.getKey(), group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String test() {
        return "Hallo Heiko";
    }

    public static double getNumeric(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            log.error("Exception:" + nfe.getMessage(), (Throwable)nfe);
            return 0.0;
        }
        return d;
    }

    @Override
    public String moveUserFromGroupToGroup(ConfluenceUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            Group thetoGroup = this.groupManager.getGroup(toGroup);
            this.disableUserFromGroup(user, theGroup, thetoGroup, move, true);
            theLog.append(user.getName() + "=>" + thetoGroup.getName() + "</br>\n");
            return theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ConfluenceUser user = this.userAccessor.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            for (ConfluenceUser it : this.userAccessor.getMembers(theGroup)) {
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(this.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public boolean disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move) {
        return this.disableUserFromGroup(user, group, groupDisabled, move, false);
    }

    public boolean disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move, boolean isWeb) {
        block10: {
            if (log.isDebugEnabled()) {
                log.info("IUMHelperService disableUserFromGroup: user {}  from group {} to group {} , move={} isWeb={} ", new Object[]{user.getName(), group.getName(), groupDisabled.getName(), move, isWeb});
            }
            try {
                if (!this.groupManager.hasMembership(group, (User)user)) break block10;
                if (isWeb) {
                    try {
                        this.groupManager.addMembership(groupDisabled, (User)user);
                        if (log.isDebugEnabled()) {
                            log.info("IUMHelperService disableUserFromGroup: addMembership : user {} to group {} ", new Object[]{user.getName(), groupDisabled.getName()});
                        }
                    }
                    catch (Exception e) {
                        log.error("Exception[addUserToGroup]: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (!move) break block10;
                try {
                    this.groupManager.removeMembership(group, (User)user);
                    if (log.isDebugEnabled()) {
                        log.info("IUMHelperService disableUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
                    }
                }
                catch (Exception e) {
                    log.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            catch (Exception e) {
                log.error("Exception: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return this.enableUserFromGroup(user, request);
    }

    @Override
    public CurrentUser enableUserFromGroup(ConfluenceUser user, HttpServletRequest request) {
        int maxQueueSize = 0;
        try {
            int i;
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] groupsEnabled = null;
            String[] groupsDisabled = null;
            String[] queueSizes = null;
            if (group != null) {
                groupsEnabled = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            if (queueSizeTxt != null) {
                queueSizes = queueSizeTxt.split(",");
            }
            Group[] enableGroups = new Group[groupsEnabled.length];
            Group[] disableGroups = new Group[groupsEnabled.length];
            for (int i2 = 0; i2 < groupsEnabled.length; ++i2) {
                if (this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i2])) {
                    return new CurrentUser(user, 0);
                }
                enableGroups[i2] = this.groupManager.getGroup(groupsEnabled[i2]);
                disableGroups[i2] = this.groupManager.getGroup(groupsDisabled[i2]);
            }
            CurrentUser currentUser = new CurrentUser(null, 0);
            for (i = 0; i < groupsEnabled.length; ++i) {
                int queueSize = Integer.parseInt(queueSizes[i]);
                OldestUser oldestUserFound = null;
                if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
                if (log.isDebugEnabled()) {
                    log.debug("IUMHelperService user " + user.getName() + " found in disabled group :" + groupsDisabled[i]);
                }
                int noOfUsers = this.iumHelperCacheService.fromCacheUsersForGroup(groupsEnabled[i]).size();
                if (log.isDebugEnabled()) {
                    log.debug("IUMHelperService enable group=" + enableGroups[i] + ", has=" + noOfUsers + ", max_allow=" + queueSize);
                }
                if (queueSize != 0 && noOfUsers >= queueSize) {
                    OldestUser oldestUser = this.disableOldestUser(enableGroups[i], disableGroups[i], user);
                    oldestUserFound = IUMHelperServiceImpl.isDifferentUser(oldestUser, user);
                }
                if (currentUser.noOfUsers == 0) {
                    currentUser.noOfUsers = queueSize;
                }
                int n = maxQueueSize = maxQueueSize > queueSize ? maxQueueSize : queueSize;
                if (queueSize != 0 && noOfUsers >= queueSize && (noOfUsers != queueSize || oldestUserFound == null)) continue;
                boolean guard = true;
                try {
                    this.groupManager.addMembership(enableGroups[i], (User)user);
                    this.iumHelperCacheService.removeUserAccessFromCache(user);
                    this.iumHelperCacheService.removeGroupAccessFromCache(enableGroups[i].getName());
                    if (log.isDebugEnabled()) {
                        log.debug("IUMHelperService add user " + user.getName() + " to " + enableGroups[i].getName());
                    }
                }
                catch (Exception e) {
                    log.error("Error :" + e.getMessage(), (Throwable)e);
                    guard = false;
                }
                currentUser = new CurrentUser((ConfluenceUser)(guard ? user : null), 0);
                break;
            }
            if (currentUser.user != null) {
                for (i = 0; i < groupsEnabled.length; ++i) {
                    if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i]) || this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i])) continue;
                    this.groupManager.addMembership(enableGroups[i], (User)user);
                    this.iumHelperCacheService.removeUserAccessFromCache(user);
                    this.iumHelperCacheService.removeGroupAccessFromCache(enableGroups[i].getName());
                    if (!log.isDebugEnabled()) continue;
                    log.debug("IUMHelperService multi-group add user " + user.getName() + " to " + enableGroups[i].getName());
                }
            } else if (currentUser.noOfUsers == 0) {
                currentUser.noOfUsers = maxQueueSize;
            }
            return currentUser;
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
            return new CurrentUser(null, maxQueueSize);
        }
    }

    @Override
    public List<Group> forceEnableUserFromGroup(ConfluenceUser user) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            if (StringUtils.isEmpty((String)group) || StringUtils.isEmpty((String)groupDisabled)) {
                return groupList;
            }
            String[] groupsEnabled = group.split(",");
            String[] groupsDisabled = groupDisabled.split(",");
            Group[] enableGroups = new Group[groupsEnabled.length];
            Group[] disableGroups = new Group[groupsEnabled.length];
            for (int i = 0; i < groupsEnabled.length; ++i) {
                enableGroups[i] = this.groupManager.getGroup(groupsEnabled[i]);
                disableGroups[i] = this.groupManager.getGroup(groupsDisabled[i]);
                if (this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i]) || !this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
                try {
                    this.groupManager.addMembership(enableGroups[i], (User)user);
                    if (log.isDebugEnabled()) {
                        log.debug("IUMHelperService add user " + user.getName() + " to " + enableGroups[i].getName());
                    }
                    groupList.add(enableGroups[i]);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error :" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return groupList;
    }

    @Override
    public boolean forceDisableUserFromGroup(ConfluenceUser user, List<Group> groupList) {
        boolean retVal = false;
        try {
            for (Group group : groupList) {
                this.groupManager.removeMembership(group, (User)user);
                if (!log.isDebugEnabled()) continue;
                log.debug("IUMHelperService remove user (REST)" + user.getName() + " to " + group.getName());
            }
            retVal = true;
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return retVal;
    }

    @Override
    public OldestUser disableOldestUser(Group groupEnabled, Group groupDisabled, ConfluenceUser user) {
        long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
        Timestamp refTime = new Timestamp(System.currentTimeMillis() - duration);
        long now = new Timestamp(System.currentTimeMillis()).getTime();
        List<OldestUser> oldestUserList = this.getOldestUser(groupEnabled, user, refTime, 10);
        if (oldestUserList.size() > 0) {
            for (OldestUser oldestUser : oldestUserList) {
                if (oldestUser == null || oldestUser.user == null) continue;
                long diff = now - oldestUser.ts;
                if (oldestUser.ts != 0L && duration != 0L && diff <= duration) continue;
                if (log.isDebugEnabled()) {
                    log.debug("disableOldestUser oldestUser={}  diff={} duration={}", new Object[]{oldestUser.user.getName(), diff, duration});
                }
                if (!this.disableUserFromGroup(oldestUser.user, groupEnabled, groupDisabled, true)) continue;
                this.iumHelperCacheService.removeUserAccessFromCache(oldestUser.user);
                this.iumHelperCacheService.removeGroupAccessFromCache(groupEnabled.getName());
                return oldestUser;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("disableOldestUser NO oldest user that {} ", new Object[]{user.getName()});
        }
        return new OldestUser(user, 0L);
    }

    public List<OldestUser> getOldestUser(Group group, ConfluenceUser appUser, Timestamp refTime, int cnt) {
        ArrayList<OldestUser> oldestUserList = new ArrayList<OldestUser>();
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group.getName(), refTime, 0, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    oldestUserList.add(new OldestUser(this.userAccessor.getUserByName(navUser.getUserName()), navUser.getLastAccessTime().getTime()));
                } else if (navUser.getUserNameEx() != null) {
                    oldestUserList.add(new OldestUser(this.userAccessor.getUserByName(navUser.getUserNameEx()), 0L));
                }
                if (oldestUserList.size() <= cnt) continue;
                break;
            }
        }
        Collections.sort(oldestUserList, OldestUser.TIME_ASC_COMPARATOR);
        return oldestUserList;
    }

    @Override
    @Deprecated
    public List<OldestUser> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUserList = this.pocketRepository.getOldestUsers(group, filtergroup, 0, max);
            ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
            for (NavUserDTO navUser : navUserList) {
                ConfluenceUser user = this.userAccessor.getUserByName(navUser.getUserNameEx() != null ? navUser.getUserNameEx() : navUser.getUserName());
                if (user != null) {
                    OldestUser oUser = new OldestUser(user, navUser.getLastAccessTime() == null ? 0L : navUser.getLastAccessTime().getTime());
                    tmpUserList.add(oUser);
                }
                if (tmpUserList.size() <= max) continue;
                break;
            }
            return tmpUserList;
        }
        return Collections.emptyList();
    }

    @Override
    public void moveUserToDisabled(ConfluenceUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!this.userManager.isUserInGroup(user.getKey(), groups[i])) continue;
            try {
                Group theGroup = this.groupManager.getGroup(groups[i]);
                Group thetoGroup = this.groupManager.getGroup(groupsDisabled[i]);
                if (theGroup != null && thetoGroup != null) {
                    this.disableUserFromGroup(user, theGroup, thetoGroup, true);
                }
            }
            catch (EntityException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
            }
            this.iumHelperCacheService.removeGroupAccessFromCache(group);
        }
        this.iumHelperCacheService.removeUserAccessFromCache(user);
    }

    @Override
    public List<String> getOnlyDisabledUsers() {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<String>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = null;
        String IUMEnable = DAO.getIUMGroups();
        IUMEnables = IUMEnable == null || IUMEnable.length() == 0 ? new String[]{} : IUMEnable.split(",");
        HashSet usersSet = new HashSet();
        for (int i = 0; i < IUMDisables.length; ++i) {
            try {
                Group gEnable;
                Group gDisable = this.groupManager.getGroup(IUMDisables[i]);
                if (gDisable == null || (gEnable = this.groupManager.getGroup(IUMEnables[i])) == null) continue;
                List disabledUserName = this.userAccessor.getMemberNamesAsList(gDisable);
                List enabledUserName = IUMEnables.length > i ? this.userAccessor.getMemberNamesAsList(gEnable) : new ArrayList();
                disabledUserName.removeAll(enabledUserName);
                usersSet.addAll(disabledUserName);
                continue;
            }
            catch (EntityException e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(usersSet);
    }

    @Override
    public List<String> getInactiveUsers4EnabledGroups(long refTS) {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<String>();
        }
        String IUMEnable = DAO.getIUMGroups();
        if (IUMEnable == null || IUMEnable.length() == 0) {
            return new ArrayList<String>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = IUMEnable.split(",");
        ArrayList<String> inactiveUsers = new ArrayList<String>();
        for (int i = 0; i < IUMEnables.length; ++i) {
            try {
                List<NavUserDTO> navUserList = this.pocketRepository.getNavUserForGroupLtTime(IUMEnables[i], IUMDisables[i], new Timestamp(refTS));
                inactiveUsers.addAll(navUserList.stream().map(navUser -> {
                    if (navUser.getUserName() != null) {
                        return navUser.getUserName();
                    }
                    return navUser.getUserNameEx();
                }).collect(Collectors.toList()));
                continue;
            }
            catch (Exception e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return inactiveUsers;
    }

    @Override
    public List<String> getInactiveUsers4EnabledGroups(long refTS, int cnt) {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<String>();
        }
        String IUMEnable = DAO.getIUMGroups();
        if (IUMEnable == null || IUMEnable.length() == 0) {
            return new ArrayList<String>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = IUMEnable.split(",");
        ArrayList<String> inactiveUsers = new ArrayList<String>();
        for (int i = 0; i < IUMEnables.length; ++i) {
            try {
                List<NavUserDTO> navUserList = this.pocketRepository.getNavUserForGroupLtTime(IUMEnables[i], IUMDisables[i], new Timestamp(refTS), cnt);
                inactiveUsers.addAll(navUserList.stream().map(navUser -> {
                    if (navUser.getUserName() != null) {
                        return navUser.getUserName();
                    }
                    return navUser.getUserNameEx();
                }).collect(Collectors.toList()));
                continue;
            }
            catch (Exception e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return inactiveUsers;
    }

    @Override
    public void removeUserFromGroup(String user, String enableGroup) {
        try {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user);
            this.removeUserFromGroup(confluenceUser, enableGroup);
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeUserFromGroup(ConfluenceUser user, String enableGroup) {
        try {
            String[] enableGroups = enableGroup.split(",");
            List groups = this.userAccessor.getGroups((User)user).getCurrentPage();
            for (Group group : groups) {
                if (!IUMHelperServiceImpl.check(enableGroups, group.getName())) continue;
                this.groupManager.removeMembership(group, (User)user);
                if (!log.isDebugEnabled()) continue;
                log.info("IUMHelperService removeUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
            }
        }
        catch (EntityException e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getQuotaForGroupOfUsername(ConfluenceUser user) {
        int quota = 0;
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String[] groupsDisabled = null;
        String[] queueSizes = null;
        if (user == null) {
            return quota;
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        if (queueSizeTxt != null) {
            queueSizes = queueSizeTxt.split(",");
        }
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
            return Integer.parseInt(queueSizes[i]);
        }
        return quota;
    }

    @Override
    public Quota checkCanGetFreeSlots(String username) throws EntityException {
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (groupEnabled == null || groupDisabled == null || queueSizeTxt == null || user == null) {
            return Quota.Empty;
        }
        String[] groupsDisabled = groupDisabled.split(",");
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
            int qs = Integer.parseInt(queueSizes[i]);
            int queue = 0;
            if (this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i]) && (queue = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(groupsEnabled[i])).size()) < qs) {
                return new Quota(qs, qs - queue);
            }
            if (!this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i])) continue;
            return new Quota(qs, 1);
        }
        return Quota.Empty;
    }

    @Override
    public List<String> getConfluenceGroups() {
        ArrayList<String> groups = new ArrayList();
        try {
            List globalPermission = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            groups = globalPermission.stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    @Override
    public List<String> getOnlyConfluenceGroups() {
        List<String> groups = new ArrayList<String>();
        try {
            List globalPermission = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            Set confluencePermission = this.spacePermissionManager.getGlobalPermissions("ADMINISTRATECONFLUENCE").stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).collect(Collectors.toSet());
            Set systemPermission = this.spacePermissionManager.getGlobalPermissions("SYSTEMADMINISTRATOR").stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).collect(Collectors.toSet());
            groups = globalPermission.stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).filter(grp -> !confluencePermission.contains(grp) && !systemPermission.contains(grp)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    @Override
    public List<String> getAllGroups() {
        ArrayList<String> groups = new ArrayList();
        try {
            groups = this.userAccessor.getGroupsAsList().stream().map(Entity::getName).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    @Override
    public Group getGroupByName(String groupName) throws EntityException {
        return this.groupManager.getGroup(groupName);
    }

    @Override
    public List<ConfluenceUser> getUsersFromGroup(String groupName) throws EntityException {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            Iterable iterable = this.userAccessor.getMembers(group);
            for (ConfluenceUser it : iterable) {
                users.add(it);
            }
        }
        return users;
    }

    @Override
    public List<ConfluenceUser> getUsersFromGroup(Group group) throws EntityException {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        if (group != null) {
            Iterable iterable = this.userAccessor.getMembers(group);
            for (ConfluenceUser it : iterable) {
                users.add(it);
            }
        }
        return users;
    }

    @Override
    public void removeUserFromGroup(ConfluenceUser user, Group group) {
        if (group == null || user == null) {
            return;
        }
        try {
            this.groupManager.removeMembership(group, (User)user);
            if (log.isDebugEnabled()) {
                log.info("IUMHelperService removeUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
            }
        }
        catch (EntityException e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addUserToGroup(ConfluenceUser user, Group group) {
        if (group == null || user == null) {
            return;
        }
        try {
            this.groupManager.addMembership(group, (User)user);
            if (log.isDebugEnabled()) {
                log.info("IUMHelperService removeUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
            }
        }
        catch (EntityException e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addUsersToGroup(Set<ConfluenceUser> confluenceUsers, Group group) {
        if (group == null || confluenceUsers == null) {
            return;
        }
        if (confluenceUsers.size() == 0) {
            return;
        }
        if (this.membershipDao == null) {
            log.warn("IUMHelperService membershipDao=NULL");
            return;
        }
        try {
            for (ConfluenceUser confluenceUser : confluenceUsers) {
                try {
                    log.info("IUMHelperService addUsersToGroup: confluenceUser# {} from group {} ", new Object[]{confluenceUser.getName(), group.getName()});
                    this.groupManager.addMembership(group, (User)confluenceUser);
                }
                catch (Exception e) {
                    log.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    private static <T> Set<T> getIntersection(List<T> list1, List<T> list2) {
        HashSet<T> result = new HashSet<T>();
        for (T elem1 : list1) {
            if (!list2.contains(elem1)) continue;
            result.add(elem1);
        }
        return result;
    }

    private static boolean check(String[] array, String value) {
        boolean test = false;
        for (String item : array) {
            if (!item.equals(value)) continue;
            test = true;
            break;
        }
        return test;
    }

    @Override
    public Set<String> getUserNamesWithConfluenceAccessOtherIUM() {
        String[] groupsName;
        HashSet<String> users = new HashSet<String>();
        HashSet<String> enableGroups = new HashSet<String>();
        for (String group : groupsName = DAO.getIUMGroups().split(",")) {
            enableGroups.add(group);
        }
        ArrayList groups = new ArrayList();
        try {
            List globalPermission = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            Set tmpUsers = globalPermission.stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).filter(xgroup -> !enableGroups.contains(xgroup)).flatMap(xgroupx -> {
                ArrayList xusers = new ArrayList();
                if (xgroupx != null) {
                    try {
                        Group realGroup = this.groupManager.getGroup(xgroupx);
                        if (realGroup != null) {
                            xusers.addAll(this.userAccessor.getMemberNamesAsList(realGroup));
                        }
                    }
                    catch (EntityException e) {
                        log.error("EntityException " + e.getMessage(), (Throwable)e);
                    }
                }
                return xusers.stream();
            }).collect(Collectors.toSet());
            users.addAll(tmpUsers);
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return users;
    }

    @Override
    public Set<ConfluenceUser> getUsersWithConfluenceAccessOtherIUM() {
        String[] groupsName;
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        HashSet<String> enableGroups = new HashSet<String>();
        for (String group : groupsName = DAO.getIUMGroups().split(",")) {
            enableGroups.add(group);
        }
        try {
            List globalPermission = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            Set tmpUsers = globalPermission.stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).filter(xgroup -> !enableGroups.contains(xgroup)).flatMap(xgroupx -> {
                ArrayList xusers = new ArrayList();
                if (xgroupx != null) {
                    try {
                        Group realGroup = this.groupManager.getGroup(xgroupx);
                        if (realGroup != null) {
                            Iterable members = this.userAccessor.getMembers(realGroup);
                            members.forEach(xusers::add);
                        }
                    }
                    catch (EntityException e) {
                        log.error("EntityException " + e.getMessage(), (Throwable)e);
                    }
                }
                return xusers.stream();
            }).collect(Collectors.toSet());
            users.addAll(tmpUsers);
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return users;
    }

    @Override
    public Set<ConfluenceUser> getUsersWithConfluenceUserAccess() {
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        ArrayList groups = new ArrayList();
        try {
            List globalPermission = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            Set tmpUsers = globalPermission.stream().filter(spacePermission -> spacePermission != null && spacePermission.getGroup() != null).map(SpacePermission::getGroup).flatMap(tmpGroup -> {
                ArrayList xusers = new ArrayList();
                if (tmpGroup != null) {
                    try {
                        Group realGroup = this.groupManager.getGroup(tmpGroup);
                        if (realGroup != null) {
                            Iterator iterator = this.userAccessor.getMembers(realGroup).iterator();
                            while (iterator.hasNext()) {
                                xusers.add(iterator.next());
                            }
                        }
                    }
                    catch (EntityException e) {
                        log.error("EntityException " + e.getMessage(), (Throwable)e);
                    }
                }
                return xusers.stream();
            }).collect(Collectors.toSet());
            users.addAll(tmpUsers);
        }
        catch (Exception e) {
            log.error("Exception= " + e.getMessage(), (Throwable)e);
        }
        return users;
    }

    @Override
    public int countLicenseConsumingUsers() {
        return this.userAccessor.countLicenseConsumingUsers();
    }

    private static OldestUser isDifferentUser(OldestUser oldestUserFound, ConfluenceUser user) {
        if (oldestUserFound == null || oldestUserFound.user == null || oldestUserFound.user.getName().equalsIgnoreCase(user.getName())) {
            return null;
        }
        return oldestUserFound;
    }
}

