/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.repository;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLQuery;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.AccxiaDatabaseAccessor;
import de.accxia.apps.confluence.ium.tables.QGroup;
import de.accxia.apps.confluence.ium.tables.QMembership;
import de.accxia.apps.confluence.ium.tables.QNavUser;
import de.accxia.apps.confluence.ium.tables.QUser;
import de.accxia.apps.confluence.ium.tables.QUserHistory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={PocketRepository.class})
@Named(value="PocketRepository")
public class PocketRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PocketRepository.class);
    private final AccxiaDatabaseAccessor databaseAccessor;

    public PocketRepository(AccxiaDatabaseAccessor accxiaDatabaseAccessor) {
        this.databaseAccessor = accxiaDatabaseAccessor;
    }

    @Deprecated
    public List<NavUserDTO> getAllNavUserForGroup(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName))).where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName.toLowerCase())))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllNavUserForGroup SQL = " + sqlQuery.toString());
                LOG.debug("getAllNavUserForGroup groupName = " + groupName);
                LOG.debug("getAllNavUserForGroup offset = " + offset);
                LOG.debug("getAllNavUserForGroup ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupWithGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QUser.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on(new Predicate[]{QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId), QGroup.MEMBERSHIP.lowerGroupName.eq(fromGroupName)})).innerJoin((EntityPath)QMembership.MEMBERSHIP2)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP2.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP2)).on(new Predicate[]{QGroup.MEMBERSHIP2.id.eq(QMembership.MEMBERSHIP2.parentId), QGroup.MEMBERSHIP2.lowerGroupName.eq(fromGroupName)});
            sqlQuery.where(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull()));
            sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupWithGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupWithGroupLtTime groupName = " + fromGroupName);
                LOG.debug("getNavUserForGroupWithGroupLtTime groupName = " + withGroupName);
                LOG.debug("getNavUserForGroupWithGroupLtTime timestamp = " + timestamp);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, boolean onlyActive, Timestamp timestamp, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName));
            if (onlyActive) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName)).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            } else {
                sqlQuery.where(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName);
                LOG.debug("getNavUserForGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        return this.getNavUserForGroupLtTime(groupName, true, timestamp, offset, ctx);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName))).where(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName.toLowerCase()))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, String filterGroup, int offset, int ctx) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            path.add(QUser.MEMBERSHIP.displayName);
            path.add(QUser.MEMBERSHIP.emailAddress);
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(QUser.MEMBERSHIP.lowerUserName).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where(QGroup.MEMBERSHIP.lowerGroupName.eq(filterGroupName));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName));
            if (filterGroupName != null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName)).and(QUser.MEMBERSHIP.userName.notIn(filterQuery)));
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName)));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("getOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("getOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public long countOldestUsers(String groupName, String filterGroup) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        long tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(QUser.MEMBERSHIP.lowerUserName).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where(QGroup.MEMBERSHIP.lowerGroupName.eq(filterGroupName));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[0]).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName));
            if (filterGroupName != null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName)).and(QUser.MEMBERSHIP.userName.notIn(filterQuery)));
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QGroup.MEMBERSHIP.lowerGroupName.eq(groupName)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("countOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("countOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("countOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("countOldestUsers groupName = " + groupName);
            }
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    private List<NavUserDTO> convertTuplesToNavUserDTO(List<Tuple> tupleSQLQuery) {
        ArrayList<NavUserDTO> retVal = new ArrayList<NavUserDTO>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToEventModel(tuple));
        }
        return retVal;
    }

    private NavUserDTO convertTupleToEventModel(Tuple tuple) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if (tuple.get(QNavUser.NAVUSER.id) != null) {
            navUserDTO.setID(tuple.get(QNavUser.NAVUSER.id));
            navUserDTO.setRequestCount(tuple.get(QNavUser.NAVUSER.requestCount));
            navUserDTO.setUserName(tuple.get(QNavUser.NAVUSER.userName));
            navUserDTO.setUserKey(tuple.get(QNavUser.NAVUSER.userKey));
            navUserDTO.setLastAccessTime(tuple.get(QNavUser.NAVUSER.lastAccessTime));
            navUserDTO.setCreationTime(tuple.get(QNavUser.NAVUSER.creationTime));
        }
        navUserDTO.setUserNameEx(tuple.get(QUser.MEMBERSHIP.userName));
        navUserDTO.setGroupNameEx(tuple.get(QGroup.MEMBERSHIP.groupName));
        navUserDTO.setDisplayNameEx(tuple.get(QUser.MEMBERSHIP.displayName));
        navUserDTO.setUserEmailEx(tuple.get(QUser.MEMBERSHIP.emailAddress));
        navUserDTO.setLastViewTime(tuple.get(QUserHistory.MEMBERSHIP.lastViewed) != null ? new Date(tuple.get(QUserHistory.MEMBERSHIP.lastViewed)) : null);
        return navUserDTO;
    }
}

