/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/test")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class TestServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    private PocketRepository pocketRepository;
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Inject
    public TestServlet(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, PocketRepository pocketRepository, RecentlyViewedManager recentlyViewedManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.recentlyViewedManager = recentlyViewedManager;
        this.pocketRepository = pocketRepository;
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserAction4Group(@QueryParam(value="group") String groupName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Group group = this.groupManager.getGroup(groupName);
            Iterable users = this.userAccessor.getMembers(group);
            for (ConfluenceUser user : users) {
                if (this.userManager.isAdmin(user.getKey())) continue;
                List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
                long lastViewed = 0L;
                if (recent.size() > 0) {
                    lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
                }
                map.put(user.getName(), lastViewed != 0L ? SDF.format(new Date(lastViewed)) : "Never");
            }
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception" + e.getMessage(), (Throwable)e);
            return Response.ok(map).build();
        }
    }

    @Path(value="/nav1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getAllNavUserForGroup(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInactiveActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String group2 = request.getParameter("group2");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(group, group2, ts);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupWithGroupLtTime(@Context HttpServletRequest request) {
        String fromGroupName = request.getParameter("fromGroupName");
        String withGroupName = request.getParameter("withGroupName");
        long inactivityInterval = ParseUtil.safeParseInt(request.getParameter("time"));
        long refTS = System.currentTimeMillis() - inactivityInterval * 60L * 1000L;
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(fromGroupName, withGroupName, new Timestamp(refTS));
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav5")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, true, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav6")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav7")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav8")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            long countOldestUsers = this.pocketRepository.countOldestUsers(group, filtergroup);
            return Response.ok((Object)countOldestUsers).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }
}

