/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.user.User;
import de.accxia.apps.confluence.ium.util.NotificationHelper;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={NotificationHelper.class})
public class NotificationHelperImpl
implements NotificationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHelperImpl.class);

    @Override
    public boolean isUserWatchingContent(User user, NotificationManager notificationManager, ContentEntityObject entityObject) {
        if (user != null && entityObject != null) {
            try {
                return notificationManager.getNotificationByUserAndContent(user, entityObject) != null;
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isUserWatchingPage(User user, NotificationManager notificationManager, Page page) {
        if (user != null && page != null) {
            try {
                return notificationManager.getNotificationByUserAndContent(user, (ContentEntityObject)page) != null;
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isUserWatchingSpace(User user, NotificationManager notificationManager, Space space) {
        if (user != null && space != null) {
            try {
                return notificationManager.getNotificationByUserAndSpace(user, space) != null;
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isUserWatchingOwnContent(User user, UserAccessor userAccessor) {
        return user != null && userAccessor.getConfluenceUserPreferences(user).isWatchingOwnContent();
    }
}

