/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import com.atlassian.user.User;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAdministratorCondition
extends SimpleUrlReadingCondition
implements Condition {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceAdministratorCondition.class);
    private static final String ADMIN_ENABLED_PARAM = "admin-enabled";
    private final PermissionManager permissionManager;

    public ConfluenceAdministratorCondition(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected boolean isConditionTrue() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConfluenceAdministratorCondition user " + user.getName());
        }
        return this.permissionManager.isConfluenceAdministrator((User)user);
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.isConditionTrue();
    }

    protected String queryKey() {
        return ADMIN_ENABLED_PARAM;
    }
}

