/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.confluence.ium.model.NavUser;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.NavUserRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AccxiaUserSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaUserSessionTracker.class);
    public static final String URI_IMAGE = "/plugins/servlet/ium-image";
    private NavUserRepository navUserRepository;
    private final ConcurrentHashMap<String, NavUserDTO> userRequestMap;
    private final IUMHelperCacheService iumHelperCacheService;
    private final IUMHelperService iumHelperService;
    private static final int MINUTE = 60000;
    public static final Comparator<NavUserDTO> BY_LAST_ACCESS_TIME = new Comparator<NavUserDTO>(){

        @Override
        public int compare(NavUserDTO userKeySession1, NavUserDTO userKeySession2) {
            long lat1 = userKeySession1.getLastAccessTime().getTime();
            long lat2 = userKeySession2.getLastAccessTime().getTime();
            return Long.compare(lat1, lat2);
        }
    };

    @Inject
    public AccxiaUserSessionTracker(NavUserRepository navUserRepository, IUMHelperCacheService iumHelperCacheService, IUMHelperService iumHelperService) {
        this.navUserRepository = navUserRepository;
        this.iumHelperCacheService = iumHelperCacheService;
        this.iumHelperService = iumHelperService;
        this.userRequestMap = new ConcurrentHashMap();
    }

    public boolean guardInteraction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return false;
        }
        NavUserDTO navUserDTO = this.userRequestMap.get(userName);
        if (navUserDTO != null && navUserDTO.getLastAccessTime() != null) {
            long diff = System.currentTimeMillis() - navUserDTO.getLastAccessTime().getTime();
            if (System.currentTimeMillis() - navUserDTO.getLastAccessTime().getTime() > 300000L && this.iumHelperCacheService.checkFillUsersPercentageFromCache(75) && this.iumHelperCacheService.isUserInEnableGroups(userName)) {
                this.iumHelperService.moveUserToDisabled(userName);
                this.userRequestMap.remove(userName);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Check FillUsersPercentage " + userName + "  logout " + diff);
                }
                httpServletRequest.getSession().invalidate();
                try {
                    httpServletResponse.sendError(401);
                }
                catch (IOException e) {
                    LOG.error("IOException: " + e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                return true;
            }
        }
        return false;
    }

    public void recordInteraction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        NavUserDTO navUserDTO;
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return;
        }
        if (httpServletRequest.getSession().isNew()) {
            return;
        }
        if (requestURI.contains(URI_IMAGE)) {
            return;
        }
        if (requestURI.contains("/download/thumbnails/") || requestURI.contains("/download/resources/") || requestURI.contains("/download/attachments/") || requestURI.contains("/synchrony/heartbeat") || requestURI.contains("/json/start") || requestURI.contains("/json/stopheartbeatactivity.action") || requestURI.contains("/plugins/servlet/notifications-miniview") || requestURI.contains("/plugins/servlet/oidc/login") || requestURI.contains("/plugins/servlet/confluence/placeholder/macro")) {
            return;
        }
        if (!requestURI.contains("/rest/oidc/") && requestURI.contains("/rest/")) {
            return;
        }
        if (this.navUserRepository == null) {
            this.navUserRepository = (NavUserRepository)ComponentLocator.getComponent(NavUserRepository.class);
        }
        if ((navUserDTO = this.userRequestMap.get(userName)) == null || navUserDTO.getID() == null) {
            navUserDTO = this.buildNavUserDTO(httpServletRequest);
            this.userRequestMap.put(userName, navUserDTO);
        } else {
            navUserDTO.addRequestCount();
            navUserDTO.setLastAccessTime(new Date());
            this.userRequestMap.put(userName, navUserDTO);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CALL " + (httpServletRequest.getRemoteUser() == null ? "N/A" : httpServletRequest.getRemoteUser()) + " " + httpServletRequest.getRequestURI());
        }
        if (this.navUserRepository != null && (navUserDTO.getSavedTime() == null || System.currentTimeMillis() - navUserDTO.getSavedTime().getTime() > 30000L)) {
            Date currentDate = new Date();
            NavUser[] navUsers = this.navUserRepository.getByUserName(navUserDTO.getUserName());
            if (navUsers.length > 0) {
                NavUser refNavUser = navUsers[navUsers.length - 1];
                if (navUsers.length > 1) {
                    this.navUserRepository.deleteOldestExceptUsers(navUserDTO.getUserName(), refNavUser);
                }
                refNavUser = this.navUserRepository.updated(refNavUser, navUserDTO);
                navUserDTO.setID(refNavUser.getID());
                navUserDTO.setSavedTime(currentDate);
            } else {
                NavUser navUser = this.navUserRepository.save(navUserDTO);
                navUserDTO.setID(navUser.getID());
                navUserDTO.setSavedTime(currentDate);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("RecordInteraction " + (httpServletRequest.getRemoteUser() == null ? "N/A" : httpServletRequest.getRemoteUser()) + " " + httpServletRequest.getRequestURI());
            }
        }
    }

    public List<NavUserDTO> getSnapshot() {
        List<NavUserDTO> userSessions = this.userRequestMap.values().stream().collect(Collectors.toList());
        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }

    private synchronized void removeExpiredSession() {
        Iterator<Map.Entry<String, NavUserDTO>> iterator = this.userRequestMap.entrySet().iterator();
        long refTimeMillis = System.currentTimeMillis() - 1800000L;
        while (iterator.hasNext()) {
            Map.Entry<String, NavUserDTO> entry = iterator.next();
            NavUserDTO userKeySession = entry.getValue();
            if (userKeySession.getLastAccessTime().getTime() >= refTimeMillis) continue;
            iterator.remove();
        }
    }

    private NavUserDTO buildNavUserDTO(HttpServletRequest httpServletRequest) {
        NavUserDTO navUserDTO = new NavUserDTO();
        Date now = new Date();
        navUserDTO.setID(null);
        navUserDTO.setRequestCount(1L);
        navUserDTO.setUserName(httpServletRequest.getRemoteUser());
        navUserDTO.setLastAccessTime(now);
        navUserDTO.setCreationTime(now);
        return navUserDTO;
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

