/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsConditionBase;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IsUserInGuestGroupsCondition
extends IsUserInGroupsConditionBase {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGuestGroupsCondition.class);
    private static final String GUESTS = "guests";

    @Inject
    public IsUserInGuestGroupsCondition(UserManager userManager, UserAccessor userAccessor) {
        super(userManager, userAccessor);
    }

    protected boolean isConditionTrue() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (this.isUserInGroups(user.getName(), GUESTS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGuestGroupsCondition user " + user.getName() + " is in groups=" + GUESTS);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String queryKey() {
        return "IUMGuess";
    }
}

