/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.JobClusterService;
import de.accxia.apps.confluence.ium.job.JobDailyService;
import de.accxia.apps.confluence.ium.job.JobLicenseService;
import de.accxia.apps.confluence.ium.job.JobSyncService;
import de.accxia.apps.confluence.ium.job.JobWatchService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
public class IUMListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(IUMListener.class);
    public static Boolean PLUGIN_ENABLED = false;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final DAO dao;
    private final IUMHelperService helperService;
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;
    private final JobDailyService jobDailyService;
    private final JobWatchService jobWatchService;
    private final JobLicenseService jobLicenseService;

    @Inject
    public IUMListener(EventPublisher eventPublisher, JobSyncService jobSyncService, JobClusterService jobClusterService, JobWatchService jobWatchService, JobLicenseService jobLicenseService, UserAccessor userAccessor, IUMHelperService helperService, JobDailyService jobDailyService, DAO dao) {
        this.eventPublisher = eventPublisher;
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.jobDailyService = jobDailyService;
        this.jobWatchService = jobWatchService;
        this.jobLicenseService = jobLicenseService;
        this.userAccessor = userAccessor;
        this.dao = dao;
        this.helperService = helperService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        PLUGIN_ENABLED = true;
        ConditionEvaluatorIUMImpl.setSideLicense();
        if ("on".equalsIgnoreCase(DAO.getSyncWorkingJob()) && !this.jobSyncService.isWorking()) {
            this.jobSyncService.restart();
        }
        if ("on".equalsIgnoreCase(DAO.getWorkingJob()) && !this.jobClusterService.isWorking()) {
            this.jobClusterService.restart();
        }
        if (!this.jobDailyService.isWorking()) {
            this.jobDailyService.start();
        }
        if (!this.jobLicenseService.isWorking()) {
            this.jobLicenseService.start();
        }
    }

    public void destroy() throws Exception {
        DAO.propertyCachedManager.cleanup();
        this.eventPublisher.unregister((Object)this);
        try {
            if (this.jobSyncService.isWorking()) {
                this.jobSyncService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobClusterService.isWorking()) {
                this.jobClusterService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobLicenseService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        PLUGIN_ENABLED = false;
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        String userName = logoutEvent.getUsername();
        if (ConditionEvaluatorIUMImpl.isLicenseValid() && logoutEvent.getExplicitLogout()) {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            this.helperService.moveUserToDisabled(user);
        }
    }
}

