/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.model.NavUser;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={NavUserRepository.class})
@Named(value="NavUserRepository")
public class NavUserRepository {
    private static final Logger logger = LoggerFactory.getLogger(NavUserRepository.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final EntityManagerProvider entityManagerProvider;

    @Inject
    public NavUserRepository(ActiveObjects ao, EntityManagerProvider entityManagerProvider) {
        this.ao = ao;
        this.entityManagerProvider = entityManagerProvider;
    }

    public NavUser save(NavUserDTO navUserDTO) {
        logger.debug("Called save for user {}", (Object)navUserDTO.getUserName());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("REQUEST_COUNT", navUserDTO.getRequestCount());
        values.put("USER_NAME", navUserDTO.getUserName());
        values.put("USER_KEY", navUserDTO.getUserKey());
        values.put("LAST_ACCESS_TIME", navUserDTO.getLastAccessTime());
        values.put("CREATION_TIME", navUserDTO.getCreationTime());
        NavUser response = (NavUser)this.ao.create(NavUser.class, values);
        logger.debug("Successfully save for user {}", (Object)navUserDTO.getUserName());
        return response;
    }

    public NavUser update(Long id, String asessionId, String sessionId, Long requestCount, String userName, String userKey) {
        NavUser navUser = (NavUser)this.ao.get(NavUser.class, (Object)new Integer(id.intValue()));
        Date currentDate = new Date();
        if (navUser != null) {
            navUser.setRequestCount(requestCount);
            navUser.setLastAccessTime(currentDate);
            navUser.setUserName(userName);
            navUser.setUserKey(userKey);
            navUser.save();
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("REQUEST_COUNT", requestCount);
            values.put("USER_NAME", userName);
            values.put("USER_KEY", userKey);
            values.put("LAST_ACCESS_TIME", currentDate);
            values.put("CREATION_TIME", currentDate);
            navUser = (NavUser)this.ao.create(NavUser.class, values);
        }
        return navUser;
    }

    public NavUser[] getByUserName(String userName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("LAST_ACCESS_TIME DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public NavUser[] getAllByUsers(String[] userNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in ?", (Object[])userNames));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getOldestUsers(String[] userNames, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderCommaList = Arrays.stream(userNames).map(un -> "?").collect(Collectors.joining(","));
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in  ( " + placeholderCommaList + " )", (Object[])userNames).order("LAST_ACCESS_TIME ASC").limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAll ");
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select());
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for getAll");
        }
        return queryResult;
    }

    public int deleteOldestExceptUsers(String userName, NavUser navUser) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called deleteOldestExceptUsers for userName {} except ID={}", (Object)userName, (Object)navUser.getID());
        }
        int cnt = (Integer)this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(NavUser.class, "USER_NAME = ? AND ID != ? ", new Object[]{userName, navUser.getID()}));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully deleteOldestExceptUsers  for userName {} except ID={}", (Object)userName, (Object)navUser.getID());
        }
        return cnt;
    }

    public void delete(NavUser navUser) {
        this.ao.delete(new RawEntity[]{navUser});
    }

    public NavUser updated(NavUser refNavUser, NavUserDTO navUserDTO) {
        if (refNavUser != null) {
            refNavUser.setRequestCount(navUserDTO.getRequestCount());
            refNavUser.setLastAccessTime(navUserDTO.getLastAccessTime());
            refNavUser.setUserName(navUserDTO.getUserName());
            refNavUser.setUserKey(navUserDTO.getUserKey());
            refNavUser.save();
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("REQUEST_COUNT", navUserDTO.getRequestCount());
            values.put("USER_NAME", navUserDTO.getUserName());
            values.put("USER_KEY", navUserDTO.getUserKey());
            values.put("LAST_ACCESS_TIME", navUserDTO.getLastAccessTime());
            values.put("CREATION_TIME", navUserDTO.getLastAccessTime());
            refNavUser = (NavUser)this.ao.executeInTransaction(() -> (NavUser)this.ao.create(NavUser.class, values));
        }
        return refNavUser;
    }
}

