/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AdminFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AdminFilter.class);
    private final IUMHelperCacheService iumHelperCacheService;

    @Inject
    public AdminFilter(IUMHelperCacheService iumHelperCacheService) {
        this.iumHelperCacheService = iumHelperCacheService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AdminFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            String userName = httpServletRequest.getRemoteUser();
            String requestURI = httpServletRequest.getRequestURI();
            if (requestURI.contains("/admin/users/removeuserfromgroup.action")) {
                this.doProcessingRemoveUser(httpServletRequest, httpServletResponse);
            }
            if (requestURI.contains("/admin/users/adduserstogroup.action")) {
                this.doProcessingAddUser(httpServletRequest, httpServletResponse);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void doProcessingRemoveUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String groupName = httpServletRequest.getParameter("membersOfGroupTerm");
        String username = httpServletRequest.getParameter("username");
        this.iumHelperCacheService.removeUserAccessFromCache(username);
        this.iumHelperCacheService.removeGroupAccessFromCache(groupName);
    }

    public void doProcessingAddUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String groupName = httpServletRequest.getParameter("membersOfGroupTerm");
        String usernames = httpServletRequest.getParameter("usersToAdd");
        if (usernames != null) {
            for (String username : usernames.split(",")) {
                this.iumHelperCacheService.removeUserAccessFromCache(username);
            }
            this.iumHelperCacheService.removeGroupAccessFromCache(groupName);
        }
    }
}

