/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMAccessJob;
import de.accxia.apps.confluence.ium.job.IUMSyncJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ajob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobAccessRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobAccessRestController.class);
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private final AccxiaAccessMap accxiaAccessMap;
    private static LocalThread localThread = null;

    public JobAccessRestController(MonitorJobRunner monitorJobRunner, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository, AccxiaAccessMap accxiaAccessMap) {
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.accxiaAccessMap = accxiaAccessMap;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("daily_repeat_interval", DAO.getDailyRepeatInterval());
        map.put("daily_starting_from", DAO.getDailyStartingFrom());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMAccessJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMAccessJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMAccessJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMAccessJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMAccessJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMAccessJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMAccessJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMAccessJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            IUMSyncJob.getInstance().injectService(this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            IUMAccessJob.getInstance().injectService(this.accxiaAccessMap);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMAccessJobData(), IUMAccessJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobAccessRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("daily_repeat_interval", (Serializable)((Object)DAO.getDailyRepeatInterval()));
            parameters.put("daily_starting_from", (Serializable)((Object)DAO.getDailyStartingFrom()));
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            IUMAccessJob.getInstance().injectService(this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            IUMAccessJob.getInstance().injectService(this.accxiaAccessMap);
            IUMAccessJob.getInstance().injectService(this.accxiaAccessMap);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t) {
        return t != null ? t.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ConfluenceUser currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ConfluenceUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                localThread.isWorking = true;
                IUMAccessJob.getInstance().injectService(JobAccessRestController.this.helperService, JobAccessRestController.this.iumHelperCacheService, JobAccessRestController.this.jobResultRepository);
                IUMAccessJob.getInstance().injectService(JobAccessRestController.this.accxiaAccessMap);
                this.parameters.put("current_user", (Serializable)this.currentUser);
                List<ProcessResult> processResultList = IUMAccessJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                localThread.processResultList = processResultList;
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                localThread.isWorking = false;
            }
        }
    }
}

