/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.license.LicenseService;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.Constants;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMLicenseJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMLicenseJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private LicenseService licenseService;
    private static IUMLicenseJob instance;
    private HelperTrialProcessing helperTrialProcessing;

    private IUMLicenseJob() {
    }

    public static IUMLicenseJob getInstance() {
        if (instance == null) {
            instance = new IUMLicenseJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMLicenseJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Override
    public void injectService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMLicenseJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        int licenseConsumingPowerUsers = this.helperService.getUserNamesWithConfluenceAccessOtherIUM().size();
        int licenseFromQueues = this.getLicenseFromQueues();
        int serviceSeats = 0;
        if (this.licenseService != null && this.licenseService.retrieve() != null) {
            if (this.licenseService.retrieve().isUnlimitedNumberOfUsers()) {
                serviceSeats = Constants.SERVICE_SEATS;
            } else if (this.licenseService.retrieve().getMaximumNumberOfUsers() > 0) {
                serviceSeats = this.licenseService.retrieve().getMaximumNumberOfUsers();
            }
        }
        int reservedLicense = ParseUtil.safeParseInt(DAO.getReservedLicense(), 3);
        if (ConditionEvaluatorIUMImpl.isFreeVersion()) {
            if (licenseFromQueues > 5) {
                int reducedSharedLicense = licenseFromQueues - 5;
                processResultList.add(new ProcessResult("LicenseJob", String.format("The shared license were reduced by %d", reducedSharedLicense), reducedSharedLicense));
                this.decrementLicenseFromQueues(reducedSharedLicense);
            }
        } else if (serviceSeats > 0 && licenseFromQueues + licenseConsumingPowerUsers + reservedLicense > serviceSeats) {
            processResultList.add(new ProcessResult("LicenseJob", String.format("Number of users %d vs %d", licenseFromQueues + licenseConsumingPowerUsers + reservedLicense, serviceSeats), licenseFromQueues + licenseConsumingPowerUsers + reservedLicense - serviceSeats));
            this.decrementLicenseFromQueues(licenseFromQueues + licenseConsumingPowerUsers + reservedLicense - serviceSeats);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMLicenseJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private int getLicenseFromQueues() {
        int licenseFromQueues = 0;
        String[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumQueueSize.length; ++i) {
            licenseFromQueues += ParseUtil.safeParseInt(iumQueueSize[i], 0);
        }
        return licenseFromQueues;
    }

    private boolean decrementLicenseFromQueues(int cnt) {
        boolean licenseFromQueues = false;
        CharSequence[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumQueueSize.length; ++i) {
            int countQueue = ParseUtil.safeParseInt(iumQueueSize[i], 0);
            if (countQueue > cnt) {
                iumQueueSize[i] = String.valueOf(countQueue - cnt);
                cnt = 0;
                break;
            }
            iumQueueSize[i] = String.valueOf(1);
            cnt = cnt - countQueue + 1;
        }
        DAO.updateQueueSize(String.join((CharSequence)",", iumQueueSize));
        return cnt == 0;
    }
}

