/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DisabledUserManager;
import com.google.common.collect.Sets;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.AlertType;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMSyncJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMSyncJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private DisabledUserManager disabledUserManager;
    private HelperTrialProcessing helperTrialProcessing;
    int syncUsers = 0;

    private IUMSyncJob() {
    }

    public static IUMSyncJob getInstance() {
        if (instance == null) {
            instance = new IUMSyncJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMSyncJob.instance.helperService = helperService;
        IUMSyncJob.instance.iumHelperCacheService = iumHelperCacheService;
        IUMSyncJob.instance.jobResultRepository = jobResultRepository;
        IUMSyncJob.instance.helperTrialProcessing = helperTrialProcessing;
    }

    @Override
    public void injectService(DisabledUserManager disabledUserManager) {
        IUMSyncJob.instance.disabledUserManager = disabledUserManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = (String)((Object)parameters.get("source_all_groups"));
        String targetGroup = (String)((Object)parameters.get("target_all_group"));
        String currentUser = (String)((Object)parameters.get("current_user"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.helperService != null) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            Set<ConfluenceUser> confluenceUserAccess = this.helperService.getUsersWithConfluenceUserAccess();
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || ParseUtil.isEmpty(arraySourceGroups[i]) || ParseUtil.isEmpty(arrayTargetGroups[i])) continue;
                ProcessResult processResult = this.processPair(currentUser, arraySourceGroups[i], arrayTargetGroups[i], confluenceUserAccess);
                processResultList.add(processResult);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied() + " to groups " + targetGroup);
                this.LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved() + " from groups " + targetGroup);
            }
            this.iumHelperCacheService.removeAllCache();
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMSyncJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    /*
     * Unable to fully structure code
     */
    private ProcessResult processPair(String currentUser, String sourceGroups, String targetGroup, Set<ConfluenceUser> confluenceUserAccess) {
        v0 = arraySourcGroups = ParseUtil.isEmpty(sourceGroups) != false ? null : sourceGroups.split(";");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, IUMSyncJob.SDF.format(new Date())});
        }
        processResult = new ProcessResult("SyncJob", sourceGroups, targetGroup);
        targetUsers = new ArrayList<String>();
        if (arraySourcGroups != null && arraySourcGroups.length > 0 && targetGroup != null && targetGroup.length() > 0) {
            try {
                confluenceTargetGroup = this.helperService.getGroupByName(targetGroup);
                targetUsers.addAll(this.helperService.getActiveMemberNames(targetGroup));
                sourceUsers = new ArrayList<String>();
                for (String group : arraySourcGroups) {
                    sourceUsers.addAll(this.helperService.getActiveMemberNames(group));
                }
                targetUserSet = targetUsers.stream().collect(Collectors.toSet());
                sourceUserSet = sourceUsers.stream().collect(Collectors.toSet());
                confluenceUserAccessSet = confluenceUserAccess.stream().map((Function<ConfluenceUser, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lcom/atlassian/confluence/user/ConfluenceUser;)Ljava/lang/String;)()).collect(Collectors.toSet());
                set2AddView = Sets.difference((Set)Sets.difference(sourceUserSet, targetUserSet), confluenceUserAccessSet);
                set2RemoveView = Sets.difference((Set)Sets.difference(targetUserSet, sourceUserSet), confluenceUserAccessSet);
                processResult.setUserRemoved(0L);
                removeConfluenceUsers = set2RemoveView.stream().collect(Collectors.toSet());
                this.helperService.removeUserNamesFromGroup(removeConfluenceUsers, confluenceTargetGroup);
                processResult.setUserRemoved(removeConfluenceUsers.size());
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info("IUMSyncJob removed users# {} to groups {} ", new Object[]{removeConfluenceUsers.size(), targetGroup});
                }
                processResult.setUserCopied(0L);
                addedConfluenceUsers = set2AddView.stream().collect(Collectors.toSet());
                freeProcessing = this.helperTrialProcessing.exceedLimitByCopyUsers2TargetGroup(targetGroup, addedConfluenceUsers);
                if (freeProcessing.isFree() && freeProcessing.isWarning()) {
                    alertDTO = this.helperTrialProcessing.markSyncProcessingError(AlertType.ALERT_JOBSYNC, currentUser, targetGroup, set2AddView.size());
                    processResult.setError(alertDTO.getMessage());
                }
                this.helperService.addUserNamesToGroup(addedConfluenceUsers, confluenceTargetGroup);
                processResult.setUserCopied(addedConfluenceUsers.size());
                if (!this.LOG.isInfoEnabled()) ** GOTO lbl43
                this.LOG.info("IUMSyncJob added users# {} to groups {} ", new Object[]{addedConfluenceUsers.size(), targetGroup});
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return processResult;
            }
        } else {
            this.LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }
lbl43:
        // 4 sources

        processResult.setElapsedTime(System.currentTimeMillis() - processResult.getStartTimestamp());
        return processResult;
    }
}

