/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.search;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class GroupUserSearcher {
    private Logger LOG = LoggerFactory.getLogger(GroupUserSearcher.class);
    private final CrowdService crowdService;

    public GroupUserSearcher(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public List<User> getActiveUsersInGroup(String groupName, int startIndex, int maxResults) {
        ArrayList<User> activeUsers = new ArrayList<User>();
        try {
            MembershipQuery findUsersQuery = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), (String[])new String[]{groupName});
            return StreamSupport.stream(this.crowdService.search((Query)findUsersQuery).spliterator(), false).filter(u -> u.isActive()).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return activeUsers;
        }
    }

    public List<String> getActiveUserNamesInGroup(String groupName, int startIndex, int maxResults) {
        ArrayList<String> activeUsers = new ArrayList<String>();
        try {
            MembershipQuery findUsersQuery = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), (String[])new String[]{groupName});
            return StreamSupport.stream(this.crowdService.search((Query)findUsersQuery).spliterator(), false).filter(u -> u.isActive()).map(u -> u.getName()).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return activeUsers;
        }
    }
}

