var IUMLogout = new function() {
	let self=this;
	let theTimer;
	let INTERVAL=15000;
	const DELTA=300;
	const ONE_MINUTE=60 * 1000;
	const DEBUG=false;
	const IUM_CHECK_ACCESS_PING='confluence_ium_check_access_ping'
	const IUM_CHECK_ACCESS_LOGOUT='confluence_ium_check_access_logout'
	let the403Patch=0;
	let theLastUserName;
	//cache latest permission to compare with current

	let doDisabled=function(force){
		//debugger

		if(force){
			//clean - IUM_CHECK_ACCESS_PING/IUM_CHECK_ACCESS_LOGOUT
			self.theLastUserName=null;
			window.localStorage.removeItem(IUM_CHECK_ACCESS_PING);
			window.localStorage.removeItem(IUM_CHECK_ACCESS_LOGOUT);

			AJS.$(".ium_removal").show();
			AJS.$(".ium_queue").hide();

			return;
		}


		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			let redirectPage = encodeURIComponent(window.location.pathname.replace(AJS.contextPath(), ''));
			document.location.href =  AJS.contextPath() + '/login.action?permissionViolation=true&os_destination=' + redirectPage;
			//document.location.href=AJS.$("#logout-link").attr("href")
		}

	}
	
	let checkApplicationAccess=function(){
		//1. header
		let userName=AJS.Meta.get("remote-user");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}
		if(!userName) {userName=AJS.$("#user-menu-link").attr("data-username");}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			let dateNow = Date.now();
			let dateStr = window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
			let dateRef =null;
			if(dateStr){
				try {
					dateRef = JSON.parse(dateStr);
					let dateDiff = dateNow - dateRef.timestamp;
					if(DEBUG){
						console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
					}

					if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === userName)) {
						if(DEBUG){
							console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
						}
						doProcessData(dateRef, false);
						return;
					}
				} catch (error) {
					console.error(error);
					dateRef =null;
				}
			}


			if(DEBUG){
				if(dateRef && dateRef.timestamp){
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
				}else{
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
				}
			}

			self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps/active");
		}	
	}
	
	this.startLogoutWatcher=function(period){
		the403Patch=0;
		period = period ? period * ONE_MINUTE : ONE_MINUTE;
		INTERVAL =Math.ceil( period/4);
		INTERVAL= INTERVAL<ONE_MINUTE ? INTERVAL :ONE_MINUTE;
		checkApplicationAccess()
		theTimer=setInterval(checkApplicationAccess, INTERVAL);

		window.addEventListener('storage', function(event) {
			// Check the changed key and react accordingly
			if (event.key === IUM_CHECK_ACCESS_LOGOUT) {
				let datRef =JSON.parse(event.newValue);
				if(self.theLastUserName === datRef.username){
					doDisabled(!!datRef.force);
				}
			}
		});
	}

	let callDisabledOrLogout=function(force){
		the403Patch=0;
		clearInterval(theTimer);
		let dateRef={username:self.theLastUserName, timestamp:Date.now(),force:force};
		window.localStorage.setItem(IUM_CHECK_ACCESS_LOGOUT,JSON.stringify(dateRef));
		doDisabled(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	let doProcessData=function(data,withSaving){
		if (!data ){
			callDisabledOrLogout();
			return
		}
		// console.warn("data="+ JSON.stringify(data));
		if (Object.keys(data).length==0){
			callDisabledOrLogout();
			return;
		}
		try {

			//we have data valid
			//our special case ?
			if(!data.username && !data.enabled){
				the403Patch++;
				if (the403Patch > 2) {
					callDisabledOrLogout();
				}
				return
			}

			if (!data.enabled){
				callDisabledOrLogout();
				return
			}

			the403Patch=0;

		}finally {
			if(withSaving){
				data.timestamp = Date.now();
				window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
				if(DEBUG){
					console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
				}
			}
		}
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				doProcessData(data,true)
			},
			error :function (xhr, ajaxOptions, thrownError) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callDisabledOrLogout(true);
						return;
					}

					callDisabledOrLogout();
				}
			}
		});
	};

	this.loadConfig4Watcher=function(){
		let url = AJS.contextPath() + "/rest/IUM/latest/apps/interval";
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				let duration = 1;
				try{
					duration=parseInt(data);
				}catch (err){
					duration=1;
				}
				IUMLogout.startLogoutWatcher(duration);
			},
			error :function (xhr, textStatus, errorThrown ) {
				if(xhr.status==401){
					console.warn("data="+ JSON.stringify(textStatus));
					return;
				}

				let duration=1;
				IUMLogout.startLogoutWatcher(duration);
			}
		});
	}
};

AJS.$( document ).ready(function() {
	// TODO PING 1min
	// IUMLogout.loadConfig4Watcher();
	IUMLogout.startLogoutWatcher(1);
});