/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IUMAccessJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobAccessService.class})
@Named(value="jobAccessService")
public class JobAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(JobAccessService.class);
    private final MonitorJobRunner monitorJobRunner;

    @Inject
    public JobAccessService(MonitorJobRunner monitorJobRunner) {
        this.monitorJobRunner = monitorJobRunner;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobAccessService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMAccessJobData(), IUMAccessJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobAccessService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMAccessJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMAccessJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMAccessJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMAccessJob.class);
    }
}

