/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IUMDailyEventJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.model.JobResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobDailyEventService.class})
@Named(value="JobDailyEventService")
public class JobDailyEventService {
    private Logger LOG = LoggerFactory.getLogger(JobDailyEventService.class);
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final JobResultRepository jobResultRepository;

    @Inject
    public JobDailyEventService(LocalNotificationService notificationService, MonitorJobRunner monitorJobRunner, IUMHelperService helperService, JobResultRepository jobResultRepository) {
        this.notificationService = notificationService;
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
        this.jobResultRepository = jobResultRepository;
    }

    public boolean start() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobDailyEventService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMDailyEventJobData(), IUMDailyEventJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobDailyEventService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMDailyEventJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMDailyEventJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMDailyEventJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyEventJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

