/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.notif;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IUMChangeDigestNotificationBean {
    private static final Logger LOG = LoggerFactory.getLogger(IUMChangeDigestNotificationBean.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final ContentEntityManager contentEntityManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final NotificationManager notificationManager;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService helperCacheService;
    private final AccxiaAccessMap accxiaAccessMap;

    public IUMChangeDigestNotificationBean(UserAccessor userAccessor, ContentEntityManager contentEntityManager, PermissionManager permissionManager, NotificationManager notificationManager, IUMHelperService helperService, IUMHelperCacheService helperCacheService, AccxiaAccessMap accxiaAccessMap) {
        this.userAccessor = userAccessor;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.notificationManager = notificationManager;
        this.helperService = helperService;
        this.helperCacheService = helperCacheService;
        this.accxiaAccessMap = accxiaAccessMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeDigestReport> getAllChangeReports(Date fromWhen) {
        ArrayList<ChangeDigestReport> reports = new ArrayList<ChangeDigestReport>();
        List<Object> updatedContent = this.getContentCreatedOrUpdatedSinceDate(fromWhen);
        updatedContent = updatedContent.stream().filter(item -> item.getTypeEnum() != ContentTypeEnum.CUSTOM).collect(Collectors.toList());
        LOG.info("Date " + fromWhen + " updatedContent=" + updatedContent.size());
        if (updatedContent.size() == 0 || !this.foundChangeReport(updatedContent)) {
            return Collections.emptyList();
        }
        List notifications = this.notificationManager.getDailyReportNotifications();
        for (Notification notification : notifications) {
            ConfluenceUser receiver = notification.getReceiver();
            String receiverName = receiver != null ? receiver.getName() : null;
            ConfluenceUser user = this.userAccessor.getUserByName(receiverName);
            if (user == null) continue;
            LOG.info("User " + receiverName + " notification=" + notification.toString());
            if (!this.helperCacheService.isUserInDisableGroups(user.getName())) continue;
            boolean forecedAdd = true;
            try {
                ChangeDigestReport changeReport;
                if (!this.helperCacheService.isUserInEnableGroups(user.getName())) {
                    forecedAdd = true;
                    this.helperService.forceEnableUserFromGroup(user.getName());
                    this.accxiaAccessMap.remove(user.getName());
                }
                if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, PermissionManager.TARGET_APPLICATION) || !(changeReport = this.getAllChangeReportForUser((User)user, updatedContent)).hasChanges()) continue;
                reports.add(changeReport);
            }
            catch (Exception e) {
                LOG.error("Exception: user=" + receiverName);
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (!forecedAdd) continue;
                this.accxiaAccessMap.add(user.getName());
            }
        }
        return reports;
    }

    public List<ContentEntityObject> getContentCreatedOrUpdatedSinceDate(Date fromWhen) {
        List fullContentList = this.contentEntityManager.getRecentlyModifiedForChangeDigest(fromWhen);
        LinkedList<ContentEntityObject> contentList = new LinkedList<ContentEntityObject>(fullContentList);
        Iterator iterator = contentList.iterator();
        while (iterator.hasNext()) {
            SpaceContentEntityObject spaceContentEntityObject;
            Space entitySpace;
            ContentEntityObject contentEntityObject = (ContentEntityObject)iterator.next();
            if (contentEntityObject instanceof Comment) {
                contentEntityObject = ((Comment)contentEntityObject).getContainer();
            }
            if (!(contentEntityObject instanceof SpaceContentEntityObject) || (entitySpace = (spaceContentEntityObject = (SpaceContentEntityObject)contentEntityObject).getSpace()) == null || !entitySpace.isPersonal()) continue;
            iterator.remove();
        }
        return contentList;
    }

    public boolean foundChangeReport(List<? extends ContentEntityObject> changes) {
        for (ContentEntityObject contentEntityObject : changes) {
            if (contentEntityObject.getType().equals("page")) {
                return true;
            }
            if (contentEntityObject.getType().equals("blogpost")) {
                return true;
            }
            if (!contentEntityObject.getType().equals("comment")) continue;
            return true;
        }
        return false;
    }

    public ChangeDigestReport getAllChangeReportForUser(User user, List<? extends ContentEntityObject> changes) {
        ChangeDigestReport report = new ChangeDigestReport(user, this.userAccessor);
        for (ContentEntityObject contentEntityObject : changes) {
            if (!this.userHasAccessTo(user, contentEntityObject)) continue;
            if (contentEntityObject.getType().equals("page")) {
                report.addPage((Page)contentEntityObject);
                continue;
            }
            if (contentEntityObject.getType().equals("blogpost")) {
                report.addBlogPost((BlogPost)contentEntityObject);
                continue;
            }
            if (contentEntityObject.getType().equals("comment")) {
                report.addComment((Comment)contentEntityObject);
                continue;
            }
            if (contentEntityObject.getType().equals("userinfo")) {
                report.addPersonalInformation((PersonalInformation)contentEntityObject);
                continue;
            }
            LOG.debug("Found content type that is not supported in a daily change digest: " + contentEntityObject.getType());
        }
        LOG.debug("User " + user.getName() + " SpaceReports=" + report.getSpaceReports().size());
        return report;
    }

    private boolean userHasAccessTo(User user, ContentEntityObject entity) {
        return this.permissionManager.hasPermissionNoExemptions(user, Permission.VIEW, (Object)entity);
    }
}

