/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.notif;

import com.atlassian.confluence.mail.jobs.DailyReportManager;
import com.atlassian.confluence.mail.jobs.DefaultDailyReportManager;
import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.mail.reports.SpaceReport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.confluence.ium.notif.IUMChangeDigestNotificationBean;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IUMDailyReportManager {
    private static final Logger LOG = LoggerFactory.getLogger(IUMDailyReportManager.class);
    @ComponentImport
    private final DailyReportManager dailyReportManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private IUMChangeDigestNotificationBean iumChangeDigestNotificationBean;

    @Inject
    public IUMDailyReportManager(DailyReportManager dailyReportManager, PermissionManager permissionManager, IUMChangeDigestNotificationBean iumChangeDigestNotificationBean) {
        this.dailyReportManager = dailyReportManager;
        this.permissionManager = permissionManager;
        this.iumChangeDigestNotificationBean = iumChangeDigestNotificationBean;
    }

    public void generateDailyReportsExemption(int dailyEventFrom) {
        Date date = DateUtils.addDays((Date)new Date(), (int)dailyEventFrom);
        try {
            this.permissionManager.withExemption(() -> {
                String subject = GeneralUtil.getI18n().getText("daily.report.title");
                List<ChangeDigestReport> reports = this.iumChangeDigestNotificationBean.getAllChangeReports(date);
                if (reports.size() > 0) {
                    for (ChangeDigestReport report : reports) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                String spaces = report.getSpaceReports().stream().map(cdr -> ((SpaceReport)cdr).getSpace().getName()).collect(Collectors.joining(","));
                                LOG.debug("spaces=  " + spaces);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.queueDailyReportEmail(subject, report);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("DailyReports queue= {}", (Object)report.getUser().getName());
                    }
                } else {
                    LOG.info("Nobody awaiting notifications");
                }
            });
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void queueDailyReportEmail(String subject, ChangeDigestReport report) {
        try {
            DefaultDailyReportManager defaultDailyReportManager = (DefaultDailyReportManager)ComponentLocator.getComponent(DefaultDailyReportManager.class);
            Class<?> clazz = defaultDailyReportManager.getClass();
            Method privateMethod = clazz.getDeclaredMethod("queueDailyReportEmail", String.class, ChangeDigestReport.class);
            privateMethod.setAccessible(true);
            privateMethod.invoke((Object)defaultDailyReportManager, subject, report);
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
        }
    }
}

