/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.saml;

import de.accxia.apps.confluence.ium.config.DAO;
import java.io.IOException;
import java.io.StringReader;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLHelper {
    private static final Logger log = LoggerFactory.getLogger(SAMLHelper.class);

    public static String decodeBase64b(String b64Data) {
        if (b64Data == null) {
            return "<Error></Error>";
        }
        byte[] dmessage = Base64.getDecoder().decode(b64Data.getBytes());
        return new String(dmessage);
    }

    public static String getUserFromSAMLResponse(String response) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(response)));
            NodeList resUser = document.getElementsByTagName(DAO.getSamlMapping());
            if (resUser.getLength() > 0 && resUser.item(0) != null) {
                String username = resUser.item(0).getTextContent();
                if (DAO.getSamlRegex() != null && DAO.getSamlRegex().length() > 0) {
                    Pattern pattern = Pattern.compile(DAO.getSamlRegex());
                    Matcher matcher = pattern.matcher(username);
                    if (matcher.find()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Found value: " + matcher.group(1));
                        }
                        username = matcher.group(1);
                    } else {
                        log.warn("Not matched for pattern " + DAO.getSamlRegex() + " : " + username);
                    }
                }
                return username;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("AccxiaError:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getSAMLUserFromSAMLResponse(String samlPar) {
        if (samlPar == null) {
            return null;
        }
        String samlXML = SAMLHelper.decodeBase64b(samlPar);
        String user = SAMLHelper.getUserFromSAMLResponse(samlXML);
        return user;
    }
}

