/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.ChangeDigestNotificationBean;
import com.atlassian.confluence.mail.jobs.DailyReportManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.IUMAlert;
import de.accxia.apps.confluence.ium.model.IUMAlertDTO;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.notif.IUMDailyReportManager;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.search.GroupUserSearcher;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/test")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class TestServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    private PocketRepository pocketRepository;
    private final GroupUserSearcher groupUserSearcher;
    @ComponentImport
    private final DailyReportManager dailyReportManager;
    @ComponentImport
    private final ContentEntityManager contentEntityManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final NotificationManager notificationManager;
    private final IUMDailyReportManager iumDailyReportManager;
    private final IUMAlertRepository iumAlertRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    @ComponentImport
    private final I18NBeanFactory i18NBeanFactory;
    @ComponentImport
    private final LocaleManager localeManager;
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Inject
    public TestServlet(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, PocketRepository pocketRepository, RecentlyViewedManager recentlyViewedManager, DailyReportManager dailyReportManager, ContentEntityManager contentEntityManager, PermissionManager permissionManager, NotificationManager notificationManager, IUMDailyReportManager iumDailyReportManager, IUMAlertRepository iumAlertRepository, GroupUserSearcher groupUserSearcher, HelperTrialProcessing helperTrialProcessing, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.recentlyViewedManager = recentlyViewedManager;
        this.pocketRepository = pocketRepository;
        this.dailyReportManager = dailyReportManager;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.notificationManager = notificationManager;
        this.iumDailyReportManager = iumDailyReportManager;
        this.iumAlertRepository = iumAlertRepository;
        this.groupUserSearcher = groupUserSearcher;
        this.helperTrialProcessing = helperTrialProcessing;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    @Path(value="/kill")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getKillSession(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        LOG.warn("Session invalidate");
        return Response.ok().build();
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserAction4Group(@QueryParam(value="group") String groupName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Group group = this.groupManager.getGroup(groupName);
            Iterable users = this.userAccessor.getMembers(group);
            for (ConfluenceUser user : users) {
                if (this.userManager.isAdmin(user.getKey())) continue;
                List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
                long lastViewed = 0L;
                if (recent.size() > 0) {
                    lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
                }
                map.put(user.getName(), lastViewed != 0L ? SDF.format(new Date(lastViewed)) : "Never");
            }
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception" + e.getMessage(), (Throwable)e);
            return Response.ok(map).build();
        }
    }

    @Path(value="/nav1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getAllNavUserForGroup(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInactiveActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String group2 = request.getParameter("group2");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(group, group2, ts);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupWithGroupLtTime(@Context HttpServletRequest request) {
        String fromGroupName = request.getParameter("fromGroupName");
        String withGroupName = request.getParameter("withGroupName");
        long inactivityInterval = ParseUtil.safeParseInt(request.getParameter("time"));
        long refTS = System.currentTimeMillis() - inactivityInterval * 60L * 1000L;
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(fromGroupName, withGroupName, new Timestamp(refTS));
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav5")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, true, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav6")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav7")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav8")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            long countOldestUsers = this.pocketRepository.countOldestUsers(group, filtergroup);
            return Response.ok((Object)countOldestUsers).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/gpage")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMemberNames(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            ArrayList retVal = new ArrayList();
            Group workGroup = this.groupManager.getGroup(group);
            Pager members = this.groupManager.getMemberNames(workGroup);
            return Response.ok((Object)PagerUtils.toList((Pager)members)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
        }
    }

    @Path(value="/gpage2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMemberNames2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<com.atlassian.crowd.embedded.api.User> retVal = this.groupUserSearcher.getActiveUsersInGroup(group, 0, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
        }
    }

    @Path(value="/cnotif")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countChangeReports(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        ChangeDigestNotificationBean changeDigestNotificationBean = new ChangeDigestNotificationBean(this.contentEntityManager, this.userAccessor, this.permissionManager, this.notificationManager);
        List changeReports = changeDigestNotificationBean.getAllChangeReports(date);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("countChangeReports: " + changeReports.size())).build();
    }

    @Path(value="/notif2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response digestNotificationBean2(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        this.permissionManager.withExemption(() -> this.dailyReportManager.generateDailyReports());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"dailyReportManager").build();
    }

    @Path(value="/notif")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response digestNotificationBean(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        this.iumDailyReportManager.generateDailyReportsExemption(-1 * days);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("GenerateDailyReports days=" + strDays)).build();
    }

    @Path(value="/alert1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAlerts(@Context HttpServletRequest request) {
        ArrayList retVal = new ArrayList();
        if (this.iumAlertRepository != null) {
            IUMAlert[] iumAlerts = this.iumAlertRepository.getActiveAlerts();
            List alertList = Arrays.stream(iumAlerts).map(IUMAlertDTO::fromAO).collect(Collectors.toList());
            return Response.ok(alertList).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing alert repository").build();
    }

    private I18NBean i18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }

    @Path(value="/prop")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProperties(@Context HttpServletRequest request) {
        String username = request.getParameter("username");
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.exceed.license"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.copy.group"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.removed.free.group"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.copy.group.html"));
        return Response.ok(retVal).build();
    }

    @Path(value="/lic")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLicense(@Context HttpServletRequest request) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (ConditionEvaluatorIUMImpl.getSideLicense() != null) {
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getAppKey());
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getCustomer());
            retVal.add(String.valueOf(ConditionEvaluatorIUMImpl.getSideLicense().getUsers()));
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getDueDate().toString());
        }
        retVal.add(DAO.getSideLicense());
        return Response.ok(retVal).build();
    }

    @Path(value="/adj")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response adjustStatus4FreeVersion(@Context HttpServletRequest request) {
        if (!ConditionEvaluatorIUMImpl.isFreeVersion()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMMembershipJob not trial at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            ArrayList retVal = new ArrayList();
            return Response.ok(retVal).build();
        }
        List<ProcessResult> processResults = this.helperTrialProcessing.adjustStatus4FreeVersion();
        return Response.ok(processResults).build();
    }
}

