/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.mentions.api.ConfluenceMentionEvent;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.IUMMentionService;
import de.accxia.apps.confluence.ium.util.IUMMentionsExcerptor;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={IUMMentionService.class})
public class IUMMentionServiceImpl
implements IUMMentionService {
    private static final Logger LOG = LoggerFactory.getLogger(IUMMentionServiceImpl.class);
    @ComponentImport
    private final Renderer renderer;
    @ComponentImport
    private final UserManager userManager;
    @ConfluenceImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    private IUMMentionsExcerptor iumMentionsExcerptor;
    private IUMHelperService iumHelperService;
    private final AccxiaAccessMap accxiaAccessMap;

    @Inject
    public IUMMentionServiceImpl(IUMMentionsExcerptor iumMentionsExcerptor, IUMHelperService iumHelperService, Renderer renderer, UserManager userManager, EventPublisher eventPublisher, UserAccessor userAccessor, AccxiaAccessMap accxiaAccessMap) {
        this.renderer = renderer;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.iumMentionsExcerptor = iumMentionsExcerptor;
        this.iumHelperService = iumHelperService;
        this.accxiaAccessMap = accxiaAccessMap;
    }

    @Override
    public void sendUserMentions(String mentionedUser, ContentEntityObject content) {
        ConfluenceUser mentionedConfluenceUser = this.userAccessor.getUserByName(mentionedUser);
        this.sendMentions(mentionedConfluenceUser, content);
    }

    @Override
    public void sendUserMentions(Set<String> mentionedUsers, ContentEntityObject content) {
        Set<ConfluenceUser> mentionedConfluenceUsers = mentionedUsers.stream().map(mentionedUser -> this.userAccessor.getUserByName(mentionedUser)).collect(Collectors.toSet());
        this.sendMentions(mentionedConfluenceUsers, content);
    }

    @Override
    public void sendMentions(ConfluenceUser mentionedUser, ContentEntityObject content) {
        this.sendMentions(Collections.singleton(mentionedUser), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMentions(Set<ConfluenceUser> mentionedUsers, ContentEntityObject content) {
        if (!mentionedUsers.isEmpty()) {
            PageContext renderContext = content.toPageContext();
            renderContext.setOutputType("email");
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
            ContentTypeEnum contentType = content.getTypeEnum();
            ConfluenceUser author = AuthenticatedUserThreadLocal.get();
            switch (contentType) {
                case COMMENT: {
                    for (ConfluenceUser recipient : mentionedUsers) {
                        try {
                            AutoCloseable asUserCloseable = AuthenticatedUserThreadLocal.asUser((ConfluenceUser)recipient);
                            try {
                                String commentMention = content.getBodyContent().getBodyType() == BodyType.XHTML ? this.renderer.render(content, (ConversionContext)conversionContext) : null;
                                this.sendUserMention(recipient, author, content, commentMention);
                            }
                            catch (Throwable e) {
                                LOG.error("Exception:" + e.getMessage(), e);
                                if (asUserCloseable != null) {
                                    try {
                                        asUserCloseable.close();
                                    }
                                    catch (Throwable throwable) {
                                        e.addSuppressed(throwable);
                                    }
                                }
                                throw e;
                            }
                            if (asUserCloseable == null) continue;
                            asUserCloseable.close();
                        }
                        catch (Exception ex) {
                            LOG.error("Exception:" + ex.getMessage(), (Throwable)ex);
                            LOG.error("Error sending comment mention. recipient: {}, author:{}, content id: {}", new Object[]{recipient.getKey(), author.getKey(), content.getId(), ex});
                        }
                    }
                    return;
                }
                case PAGE: 
                case BLOG: 
                case CUSTOM: {
                    try {
                        for (ConfluenceUser user : mentionedUsers) {
                            this.iumHelperService.forceEnableUserFromGroup(user.getName());
                            this.accxiaAccessMap.remove(user.getName());
                        }
                        for (ConfluenceUser recipientUser : mentionedUsers) {
                            String excerpt = this.iumMentionsExcerptor.getExcerpt(content, recipientUser);
                            try {
                                AutoCloseable asUserCloseable = AuthenticatedUserThreadLocal.asUser((ConfluenceUser)AuthenticatedUserThreadLocal.get());
                                try {
                                    String mentionHtml = StringUtils.isNotBlank((CharSequence)excerpt) ? this.renderer.render(excerpt, (ConversionContext)conversionContext) : null;
                                    this.sendUserMention(recipientUser, author, content, mentionHtml);
                                }
                                catch (Throwable e) {
                                    LOG.error("Exception:" + e.getMessage(), e);
                                    if (asUserCloseable != null) {
                                        try {
                                            asUserCloseable.close();
                                        }
                                        catch (Throwable throwable) {
                                            e.addSuppressed(throwable);
                                        }
                                    }
                                    throw e;
                                }
                                if (asUserCloseable == null) continue;
                                asUserCloseable.close();
                            }
                            catch (Exception var16) {
                                LOG.error("Exception:" + var16.getMessage(), (Throwable)var16);
                                LOG.error("Error sending custom mention. recipient: {}, author:{}, content id: {}", new Object[]{recipientUser.getKey(), author.getKey(), content.getId(), var16});
                            }
                        }
                    }
                    finally {
                        for (ConfluenceUser user : mentionedUsers) {
                            this.accxiaAccessMap.add(user.getName());
                        }
                        break;
                    }
                }
            }
        }
    }

    private void sendUserMention(ConfluenceUser recipient, ConfluenceUser author, ContentEntityObject content, String mentionHtml) {
        UserProfile recipientProfile = this.userManager.getUserProfile(recipient.getKey());
        ConfluenceMentionEvent event = new ConfluenceMentionEvent((Object)this, content, recipientProfile, author, mentionHtml);
        this.eventPublisher.publish((Object)event);
    }
}

