var JobSync = {
    idx:100,
    forceSubmit:false,
    initSelectStaticSrc : function(parentClass,ele ) {
        var elemParent = AJS.$("." + parentClass);
        var pickerElement = elemParent.find("." + ele + "-groupsPicker");

        var selGroups = pickerElement.data("selected")
        pickerElement.auiSelect2({
            placeholder: "Search Groups",
            minimumInputLength: 2,
            multiple: true,
            cache: true,
            width:"100%",
            initSelection: function (element, callback) {
                var data = [];
                if(element.data("selected")){
                 var grp=element.data("selected").split(",")
                    for (var i = 0; i <grp.length; i++) {
                        data.push({id: grp[i],text: grp[i]})
                    }
                }
                callback(data);
            },
            ajax: {
                url: AJS.contextPath() + "/rest/IUM/latest/gsearch/lackgroups",
                // url: AJS.contextPath() + "/rest/prototype/1/search/group.json",
                dataType: 'json',
                delay: 250,
                escapeMarkup: function (m) {
                    return m;
                },

                data: function (params) {
                    var queryParameters = {
                        "searchTerm": params,
                        "maxResults": "10"
                    }
                    return queryParameters;
                },
                results: function (data, page) {
                    /*
                      {"totalSize":0,
                      "result":[{"name":"ium_disable","type":"group"},{"name":"ium_disable2","type":"group"},{"name":"ium_disable_huge","type":"group"},{"name":"ium_enable","type":"group"},{"name":"ium_enable2","type":"group"},{"name":"ium_user_disable","type":"group"},{"name":"ium_xaccount_disable","type":"group"}],
                      "group":[]
                      }
                    */
                    var ind = -1;
                    var dataMap = [];

                    if (data.result) {
                        dataMap = data.result.map( function (item) {
                            ind++;
                            return {
                                id: item.name,
                                text: item.name
                            }
                        });
                    }


                    return {
                        results: dataMap
                    };
                }
            }
        }).select2('val', selGroups);

    },

    initSelectStaticTarget : function(parentClass,ele,defValue,preload_data ) {
        var preload= preload_data ? preload_data.split(",") : new Array();
        var elemParent = AJS.$("." + parentClass);

        var pickerElement = elemParent.find("." + ele + "-groupsPicker");
        var groupElement = elemParent.find("." + ele + "-groups");
        listValues = defValue ? defValue.split(";") : new Array();

        var selGroups = pickerElement.data("selected")
        pickerElement.auiSelect2({
            multiple: false,
            allowClear: true,
            initSelection: function (element, callback) {
                var defData =null;
                if(element && element.val()){
                    defData={id:element.val(),text:element.val()};
                }
                callback(defData);
            }
            ,query: function (query){
                var data = {results: []};

                $.each(preload, function(){
                    if(query.term.length == 0 || this.toUpperCase().indexOf(query.term.toUpperCase()) >= 0 ){
                        data.results.push({id: this, text: this });
                    }
                });

                query.callback(data);
            }
        }).select2('val', selGroups);
    },

    doSubmit: function(){
        if(JobSync.forceSubmit){
            return true;
        }

        var $elems=AJS.$(".services");
        $elems.find('.error').val("");
        var hasIssues = false;


        for (var i = 0; i < $elems.length; i ++) {
            var $elem=$($elems[i]);
            var srcSelection= $elem.find('input.src-selection');
            var targetSelection= $elem.find('input.target-selection');

            var srcSelectionVal= srcSelection.select2("val")
            var targetSelectionVal=targetSelection.select2("val")
            var errorMessage= $elem.parent().find('.error');

            if(srcSelectionVal && !targetSelectionVal) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
            if(!targetSelectionVal && srcSelectionVal) {
                hasIssues=true;
                errorMessage.text(AJS.I18n.getText('IUM-sync-inactive-rule.description'))
            }
        }

        if(hasIssues){
            AJS.dialog2("#rule-dialog").show();
            AJS.$("#rule-dialog-submit-button").click(function (e) {
                e.preventDefault();
                AJS.dialog2("#rule-dialog").hide();
                hasIssues=false;
                JobSync.forceSubmit=true;
                AJS.$("#IUM-config").submit();
            });
            AJS.$("#rule-dialog-close-button").click(function (e) {
                e.preventDefault();
                AJS.dialog2("#rule-dialog").hide();
            });
        }

        return !hasIssues;
    }
}

