var IUMUpload={
    readURL: function (input) {
        if (input.files && input.files[0]) {

            var reader = new FileReader();

            reader.onload = function (e) {
                AJS.$('.image-upload-wrap').hide();

                AJS.$('.file-upload-image').attr('src', e.target.result);
                AJS.$('.file-upload-content').show();

                if (input.files[0].size > 1024 * 1024 * 3) { // 10 MB
                    IUMUpload.removeUpload();
                    alert('File size exceeds the limit (3MB). Please select a smaller file.');
                    event.preventDefault(); // Prevent form submission
                    return;
                }else{
                    AJS.$('.image-title').html(input.files[0].name);
                    AJS.$('input[name="urlLogo"]').val(input.files[0].name)
                    IUMUpload.uploadFile(input.files)
                }
            };

            reader.readAsDataURL(input.files[0]);
        } else {
            IUMUpload.removeUpload();
        }
    },

    removeUpload:function() {
        // debugger
        AJS.$('input[name="urlLogo"]').val("")
        $('.file-upload-input').replaceWith($('.file-upload-input').clone());
        $('.file-upload-content').hide();
        $('.image-upload-wrap').show();
    },

    uploadFile:function(files) {
        //var urlFileLogo=document.querySelector("#urlFileLogo");
        //var files=urlFileLogo.files;

        if(!files || files.length ==0){
            return;
        }

        var formData = new FormData();
        formData.append('file', files[0]);

        AJS.$.ajax({
            url: AJS.contextPath() + '/plugins/servlet/ium-image', // Your servlet URL
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response){
                console.log("FileName "+response)
                // AJS.$('#urlLogo').attr("src", AJS.contextPath() + '/plugins/servlet/ium-image?fileName=' + response);
                //AJS.$('#file-name').text(response)
            },
            error: function(xhr, status, error){
                IUMUpload.removeUpload();
                // AJS.$('#urlLogo').attr("src","");
                AJS.$('#server-error').text('Error uploading file ');
                setTimeout(function (){
                   AJS.$('#server-error').text('');
                },5000)
            }
        });
    },

    fireClick:function() {
        AJS.$('.file-upload-input').trigger('click')
    },

    doSubmit: function () {

        var allFilled = true;

        if (allFilled) {
            AJS.$("#error").text("");
            return (true);
        }
        AJS.$("#error").text(AJS.I18n.getText('IUM-error.empty'));
        return (false);
    }

}


AJS.$(document).ready(function() {
    var urlFileLogo=document.querySelector("#urlFileLogo");
    if(urlFileLogo){

        AJS.$('.image-upload-wrap').bind('dragover', function () {
            AJS.$('.image-upload-wrap').addClass('image-dropping');
        });
        AJS.$('.image-upload-wrap').bind('dragleave', function () {
            AJS.$('.image-upload-wrap').removeClass('image-dropping');
        });
    }
});
