/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.job.IUMMembershipJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/mjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobMembershipRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobMembershipRestController.class);
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private final IUMAlertRepository alertRepository;
    private final PocketRepository pocketRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private static LocalThread localThread = null;

    @Inject
    public JobMembershipRestController(MonitorJobRunner monitorJobRunner, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, PocketRepository pocketRepository, JobResultRepository jobResultRepository, IUMAlertRepository alertRepository, HelperTrialProcessing helperTrialProcessing) {
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.alertRepository = alertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("membership_repeat_interval", String.valueOf(5));
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMMembershipJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMMembershipJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMMembershipJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMMembershipJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMMembershipJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMMembershipJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMMembershipJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMMembershipJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="membership_repeat_interval") String repeatinterval) {
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMMembershipJob.class);
            IUMMembershipJob.getInstance().injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            IUMMembershipJob.getInstance().injectService(this.alertRepository);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMMembershipJobData(), IUMMembershipJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMMembershipJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobMembershipRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("membership_repeat_interval", (Serializable)((Object)String.valueOf(5)));
            String currentUser = AuthenticatedUserThreadLocal.get() != null ? AuthenticatedUserThreadLocal.get().getName() : "IUMPlugin";
            parameters.put("current_user", (Serializable)((Object)currentUser));
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobMembershipRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobMembershipRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobMembershipRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobMembershipRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t) {
        return t != null ? t.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        String currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(String currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                localThread.isWorking = true;
                IUMMembershipJob.getInstance().injectService(JobMembershipRestController.this.helperTrialProcessing, JobMembershipRestController.this.helperService, JobMembershipRestController.this.iumHelperCacheService, JobMembershipRestController.this.jobResultRepository);
                IUMMembershipJob.getInstance().injectService(JobMembershipRestController.this.alertRepository);
                this.parameters.put("current_user", (Serializable)((Object)this.currentUser));
                List<ProcessResult> processResultList = IUMMembershipJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                localThread.processResultList = processResultList;
                JobMembershipRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                localThread.isWorking = false;
            }
        }
    }
}

