/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.Group;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.config.RestRoute;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    public static final String OS_DESTINATION = "os_destination";
    public static final String ORIGIN = "origin";
    public static final String URI_RESTORE = "secure/restore";
    public static final String URI_DISABLE = "secure/disable";
    public static final String URI_IMAGE = "/plugins/servlet/ium-image";
    public static final String UNDEFINED = "/undefined/";
    public static final String DISPLAY = "/display";
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService helperCacheService;
    private final AccxiaAccessMap accxiaAccessMap;
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;

    @Inject
    public IntelligentUserManagerCerberosFilter(TemplateRenderer renderer, PageBuilderService pageBuilderService, ApplicationProperties applicationProperties, AccxiaAccessMap accxiaAccessMap, UserAccessor userAccessor, IUMHelperCacheService helperCacheService, IUMHelperService helperService) {
        this.userAccessor = userAccessor;
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.helperService = helperService;
        this.helperCacheService = helperCacheService;
        this.accxiaAccessMap = accxiaAccessMap;
        this.pageBuilderService = pageBuilderService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ConfluenceUser user;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpRequest.getRequestURI() != null ? httpRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpRequest.getPathInfo() != null ? httpRequest.getPathInfo() : "N/A") + ", user=" + (httpRequest.getRemoteUser() != null ? httpRequest.getRemoteUser() : "N/A"));
        }
        if ((user = AuthenticatedUserThreadLocal.get()) == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/logout.action")) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_IMAGE)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isConfiguredIUM()) {
            if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_RESTORE)) {
                ((HttpServletResponse)response).sendRedirect(this.applicationProperties.getBaseUrl());
                return;
            }
            if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_DISABLE)) {
                ((HttpServletResponse)response).sendRedirect(this.applicationProperties.getBaseUrl());
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperCacheService.isUserInDisableGroups(user)) {
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " is not belong to IUM Disable :" + DAO.getIUMGroupsDisabled() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/fourohfour.action")) {
            ((HttpServletResponse)response).sendRedirect(this.applicationProperties.getBaseUrl());
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_DISABLE)) {
            String username;
            if (log.isDebugEnabled()) {
                log.debug("Received disable url=secure/disable " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
            }
            if ((username = request.getParameter("username")) == null || username.length() == 0) {
                ((HttpServletResponse)response).sendRedirect(httpRequest.getContextPath() + "/");
                return;
            }
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
            if (username != null && username.length() > 0 && this.helperCacheService.isUserInEnableGroups(confluenceUser) && this.helperCacheService.freshIsUserInEnableGroups(confluenceUser)) {
                if (log.isDebugEnabled()) {
                    log.debug("Redirect to the saved url | referrer | base url " + this.applicationProperties.getBaseUrl());
                }
                this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Redirect user " + username + " to the queue ");
            }
            this.renderQueueVM(this.helperService.getQuotaForGroupOfUsername(AuthenticatedUserThreadLocal.get()), httpRequest, (HttpServletResponse)response);
            return;
        }
        if (this.helperCacheService.isUserInEnableGroups(user)) {
            if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_RESTORE)) {
                if (log.isDebugEnabled()) {
                    log.debug("Received restore url=secure/restore  " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
                }
                this.helperCacheService.removeUserFromRemovalCache(user.getName());
                this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " belong to IUM Enable :" + DAO.getIUMGroups() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (this.shouldInterceptRestRequest(httpRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("InterceptRestRequest=" + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
            }
            List<Group> groupList = null;
            try {
                groupList = this.helperService.forceEnableUserFromGroup(user);
                this.accxiaAccessMap.remove(user.getName());
                chain.doFilter(request, response);
            }
            finally {
                this.accxiaAccessMap.add(user.getName());
            }
            return;
        }
        if (httpRequest.getRequestURI() != null && (httpRequest.getRequestURI().contains("/rest/IUM/latest/apps/check") || httpRequest.getRequestURI().contains("/rest/IUM/latest/apps/retry/"))) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && (httpRequest.getRequestURI().contains("/rest/") || httpRequest.getRequestURI().contains("/json/"))) {
            chain.doFilter(request, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter try to enable user = " + user.getName() + ", for pathInfo=" + (httpRequest.getPathInfo() != null ? httpRequest.getPathInfo() : "N/A"));
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter InputUser=" + user.getName() + (currentUser != null && currentUser.user != null ? "  ==> enabled with success=" + currentUser.user.getName() : " couldn't be enabled"));
        }
        if (currentUser != null) {
            if (currentUser.user != null) {
                if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_RESTORE)) {
                    if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
                        if (log.isDebugEnabled()) {
                            log.debug("Received secure/restore " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
                        }
                        this.helperCacheService.removeUserFromRemovalCache(user.getName());
                        this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                        return;
                    }
                    ((HttpServletResponse)response).sendRedirect(this.applicationProperties.getBaseUrl());
                    return;
                }
                chain.doFilter(request, response);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isConfiguredIUM() {
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String groupEnabled = DAO.getIUMGroups();
        return !StringUtils.isEmpty((String)groupDisabled) && !StringUtils.isEmpty((String)groupEnabled);
    }

    private void doGlobalRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String referrer;
        String os_destination;
        String origin = httpServletRequest.getParameter(ORIGIN);
        if (origin != null && origin.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> " + origin + " , baseUrl=" + this.applicationProperties.getBaseUrl() + " , referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A"));
            }
            if (origin.toLowerCase().startsWith("http") && !origin.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase())) {
                String referer = httpServletRequest.getHeader("referer");
                if (log.isDebugEnabled()) {
                    log.debug("doGlobalRedirect auth ==> " + this.applicationProperties.getBaseUrl() + " , referer=" + (referer != null ? referer : "N/A"));
                }
                if (referer != null && referer.toLowerCase().startsWith("http") && referer.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase())) {
                    if (referer.contains(URI_RESTORE)) {
                        httpServletResponse.sendRedirect(this.applicationProperties.getBaseUrl());
                    } else {
                        httpServletResponse.sendRedirect(referer);
                    }
                    return;
                }
                httpServletResponse.sendRedirect(this.applicationProperties.getBaseUrl());
                return;
            }
            if (origin.contains(URI_RESTORE)) {
                httpServletResponse.sendRedirect(this.applicationProperties.getBaseUrl());
            } else {
                httpServletResponse.sendRedirect(origin);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter doGlobalRedirect requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
            if (log.isTraceEnabled()) {
                this.doDebugRequestData((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        if (!((os_destination = this.extractOSDestination(referrer = httpServletRequest.getHeader("referer"))) == null || referrer.contains(URI_DISABLE) && referrer.contains(URI_RESTORE))) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> referrer " + referrer);
            }
            httpServletResponse.sendRedirect(os_destination);
            return;
        }
        if (!(referrer == null || referrer.length() <= 0 || httpServletRequest.getRequestURI() == null || !httpServletRequest.getRequestURI().contains(URI_DISABLE) && !httpServletRequest.getRequestURI().contains(URI_RESTORE) || referrer.contains(URI_DISABLE) && referrer.contains(URI_RESTORE) && referrer.contains(URLEncoder.encode(URI_DISABLE)) && referrer.contains(URLEncoder.encode(URI_RESTORE)))) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> referrer " + referrer);
            }
            httpServletResponse.sendRedirect(referrer);
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("doGlobalRedirect  ==> /");
        }
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/");
    }

    private String extractOSDestination(String referrer) {
        try {
            URI uri = new URI(referrer);
            String query = uri.getQuery();
            if (query != null) {
                String[] queryParams;
                for (String param : queryParams = query.split("&")) {
                    String[] keyValue = param.split("=");
                    if (keyValue.length != 2 || !keyValue[0].equals(OS_DESTINATION)) continue;
                    return URLDecoder.decode(keyValue[1]);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referrer;
        String baseurl = this.applicationProperties.getBaseUrl();
        String origin = request.getParameter(ORIGIN);
        if (!(origin != null && origin.length() != 0 || (referrer = request.getHeader("referer")) == null || referrer.contains(URI_DISABLE) || referrer.contains("/login.jsp"))) {
            if (log.isDebugEnabled()) {
                log.debug("Retrive referrer from request: " + referrer + " update latest ref");
            }
            origin = referrer;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("baseurl", baseurl);
        context.put(ORIGIN, origin);
        context.put("applicationProperties", this.applicationProperties);
        context.put("redirUrl", this.applicationProperties.getBaseUrl());
        context.put("duration", DAO.getDuration());
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("tempDisconnect", DAO.getTempDisconnectMessage());
        context.put("heightLogo", DAO.getHeightLogo());
        context.put("username", request.getRemoteUser());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.apps.confluence.IUM.IUM4Confluence:IUM-Check-resources");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.apps.confluence.IUM.IUM4Confluence:login-resources");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)response.getWriter(), UrlMode.ABSOLUTE);
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private boolean shouldInterceptRestRequest(HttpServletRequest request) {
        if (RestRoute.getInstance().isEmpty()) {
            return false;
        }
        String referrer = request.getHeader("referer");
        if (referrer != null && !referrer.contains("/rest")) {
            return false;
        }
        String path = request.getRequestURI();
        boolean contain = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s2 -> path.indexOf((String)s2) != -1);
        return contain;
    }

    private void doDebugRequestData(ServletRequest request, ServletResponse response) {
        try {
            Cookie[] cookies;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getQueryString() != null) {
                log.trace("QueryString=" + httpRequest.getQueryString());
            }
            for (Cookie cookie : cookies = httpRequest.getCookies()) {
                log.trace(cookie.getName() + " " + cookie.getValue());
            }
            Enumeration headerNames = httpRequest.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    log.trace(headerName + "=" + httpRequest.getHeader(headerName));
                }
            }
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                log.trace(parameterName + "=" + httpRequest.getParameter(parameterName));
            }
            Enumeration attributeNames = httpRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                log.trace(attributeName + "=" + httpRequest.getParameter(attributeName));
            }
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

