/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.Mutex;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMWatcherJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMWatcherJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMWatcherJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private HelperTrialProcessing helperTrialProcessing;
    public static final double THRESHOLD = 0.9;

    private IUMWatcherJob() {
    }

    public static IUMWatcherJob getInstance() {
        if (instance == null) {
            instance = new IUMWatcherJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMWatcherJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessResult> doProcessingJob(final Map<String, Serializable> parameters) {
        boolean locked = false;
        try {
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            if (locked) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Future retVal = executorService.submit(new Callable(){

                    public List<ProcessResult> call() throws Exception {
                        return IUMWatcherJob.this.doLocalProcessingJob(parameters);
                    }
                });
                List processResults = (List)retVal.get();
                this.LOG.info("IUMWatcherJob run #[" + SDF.format(new Date()) + "] ");
                List list = processResults;
                return list;
            }
            this.LOG.warn("IUMWatcherJob couldnt run #[" + SDF.format(new Date()) + "] ");
        }
        catch (Exception e) {
            this.LOG.error("IUMWatcherJob Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
        return Collections.emptyList();
    }

    public List<ProcessResult> doLocalProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
        long watcherInactivityDuration = TimeUnit.MINUTES.toMillis(ParseUtil.safeParseInt(DAO.getWatcherInactivityDuration(), 0));
        if (watcherInactivityDuration == 0L) {
            watcherInactivityDuration = JobData.DEFAULT_USER_INACTIVITY_SHORT_INTERVAL;
        }
        int threshold = ParseUtil.safeParseInt(DAO.getWatcherGroupLevel(), 95);
        int removalUserExpected = ParseUtil.safeParseInt(DAO.getWatcherRemovalCount(), 1);
        String enableGroups = DAO.getIUMGroups();
        String disableGroups = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Process with groups={} interval={} removalUserExpected={} threshold={} at date={} ", new Object[]{enableGroups, watcherInactivityDuration, removalUserExpected, threshold, SDF.format(new Date())});
        }
        if (StringUtils.isEmpty((String)enableGroups)) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("IUMWatcherJob skip empty group #[" + SDF.format(new Date()) + "] ");
            }
            return processResultList;
        }
        long refTS = System.currentTimeMillis() - watcherInactivityDuration;
        String[] eGroups = enableGroups.split(",");
        String[] dGroups = disableGroups.split(",");
        String[] sizes = DAO.getQueueSize().split(",");
        ArrayList<String> thresholdEnableGroup = new ArrayList<String>();
        ArrayList<String> thresholdDisableGroup = new ArrayList<String>();
        for (int i = 0; i < eGroups.length; ++i) {
            int cnt = 0;
            if (i >= sizes.length || (cnt = ParseUtil.safeParseInt(sizes[i])) <= 0 || cnt * threshold / 100 >= this.iumHelperCacheService.countFromCacheUsersForGroupReal(eGroups[i])) continue;
            thresholdEnableGroup.add(eGroups[i]);
            thresholdDisableGroup.add(dGroups[i]);
        }
        if (thresholdEnableGroup.isEmpty()) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("IUMWatcherJob skip not meet threshold - #[" + SDF.format(new Date()) + "] ");
            }
            return processResultList;
        }
        long timeExpectedToEnd = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(4L);
        boolean timeLimitReached = false;
        for (int i = 0; i < thresholdEnableGroup.size(); ++i) {
            int cnt = 0;
            String enableGroup = (String)thresholdEnableGroup.get(i);
            String disableGroup = (String)thresholdDisableGroup.get(i);
            ProcessResult processResult = new ProcessResult("LevelJob", enableGroup, disableGroup);
            processResult.setUserRemoved(0L);
            List<String> inactiveUsers = this.helperService.getInactiveUsers4EnabledGroups(enableGroup, disableGroup, refTS, 0, removalUserExpected);
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("IUMWatcherJob group={} inactiveUsers={} refTS={}/{} ", new Object[]{enableGroup, inactiveUsers.size(), refTS, SDF.format(new Date(refTS))});
            }
            try {
                Group group = groupManager.getGroup(enableGroup);
                for (String userName : inactiveUsers) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.LOG.error("InterruptedException: " + e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("IUMWatcherJob process user={}", (Object)userName);
                        }
                        this.helperService.doRemoveMembership2Group(group, userAccessor.getUserByName(userName));
                        this.iumHelperCacheService.removeUserAccessFromCache(userName);
                        this.iumHelperCacheService.addUserToRemovalCache(userName);
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                    }
                    ++cnt;
                    if (System.currentTimeMillis() > timeExpectedToEnd) {
                        this.LOG.debug("IUMWatcherJob Processed exceed time ={} ", new Object[]{timeExpectedToEnd});
                        timeLimitReached = true;
                        break;
                    }
                    if (removalUserExpected == 0 || removalUserExpected > cnt) continue;
                    this.LOG.debug("IUMWatcherJob Processed cnt ={} from {}  ", new Object[]{cnt, removalUserExpected});
                    break;
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("IUMWatcherJob Processed groups={} removed={} interval={} at [ {} ] ", new Object[]{enableGroups, processResult.getUserRemoved(), watcherInactivityDuration, SDF.format(new Date())});
                }
                this.iumHelperCacheService.removeGroupAccessFromCache(enableGroup);
                processResult.setElapsedTime(System.currentTimeMillis() - processResult.getStartTimestamp());
                processResultList.add(processResult);
                if (!timeLimitReached) continue;
                break;
            }
            catch (EntityException e) {
                this.LOG.error("EntityException " + e.getMessage(), (Throwable)e);
            }
        }
        return processResultList;
    }
}

