/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.side;

import com.atlassian.confluence.util.LicenseCalculator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.side.LicenseData;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyMessage {
    private static String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIYrjQBEg6RPMYXJwS8FxE5E/s0I5XCpIlBP3yGi4zm3sGwiwyqck40MzMCBbb+3RoBZZkpfzNr99WYa3x+jme8CAwEAAQ==";
    private static final LicenseCalculator licenseCalculator = (LicenseCalculator)ComponentLocator.getComponent(LicenseCalculator.class);
    private static final String OURAPPKEY = "de.accxia.apps.confluence.ium";
    private static Gson gson = new GsonBuilder().setDateFormat("MMM dd, yyyy HH:mm:ss a").create();
    private static final Logger log = LoggerFactory.getLogger(VerifyMessage.class);

    public static LicenseData verifyMessageString(String theMessage) throws Exception {
        byte[] vmessage;
        String[] msg = theMessage.split("\\$\\$");
        byte[] dmessage = Base64.getDecoder().decode(msg[0].getBytes());
        if (VerifyMessage.verifySignatureString(dmessage, vmessage = Base64.getDecoder().decode(msg[1].getBytes()))) {
            return gson.fromJson((Reader)new StringReader(new String(dmessage)), LicenseData.class);
        }
        log.warn("CAN NOT Verify Signature");
        return null;
    }

    public static LicenseData checkSideLicenses(PluginSettings settings) {
        String sideLicense = DAO.getSideLicense();
        if (sideLicense == null || "".equals(sideLicense)) {
            return null;
        }
        try {
            LicenseData res = VerifyMessage.verifyMessageString(sideLicense);
            return res;
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static LicenseData checkSideLicenses(String sideLicense) {
        if (sideLicense == null || "".equals(sideLicense)) {
            return null;
        }
        try {
            LicenseData res = VerifyMessage.verifyMessageString(sideLicense);
            return res;
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean verifySignatureString(byte[] data, byte[] signature) {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(VerifyMessage.getPublicFromString(publicKey));
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static License_Result getLicenseStatus(LicenseData sideLicense, String ourServerID) {
        if (sideLicense == null || sideLicense.getAppKey() == null || sideLicense.getAppKey().isEmpty()) {
            return License_Result.LICENSE_TRIAL_VALID;
        }
        if (sideLicense.getDueDate().compareTo(new Date()) < 0) {
            return License_Result.LICENSE_EXPIRED;
        }
        if (!OURAPPKEY.equals(sideLicense.getAppKey()) && !"".equals(sideLicense.getAppKey())) {
            return License_Result.LICENSE_WRONG_APPKEY;
        }
        if (!("".equals(sideLicense.getSid()) || ourServerID != null && ourServerID.equals(sideLicense.getSid()))) {
            if (log.isDebugEnabled()) {
                log.debug("ourServerID = " + ourServerID + " vs " + sideLicense.getSid());
            }
            return License_Result.LICENSE_WRONG_SERVERID;
        }
        if (licenseCalculator.getNumberOfLicensedUsers() > sideLicense.getUsers()) {
            return License_Result.LICENSE_USERS_LIMIT;
        }
        return License_Result.LICENSE_OK;
    }

    public static boolean isSideLicenseValid(LicenseData sideLicense, String ourServerID) {
        return VerifyMessage.getLicenseStatus(sideLicense, ourServerID) == License_Result.LICENSE_OK;
    }

    public static PublicKey getPublicFromString(String publicKey) throws Exception {
        byte[] keyBytes0 = publicKey.getBytes();
        byte[] keyBytes = Base64.getDecoder().decode(keyBytes0);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    public static enum License_Result {
        LICENSE_MISSING,
        LICENSE_OK,
        LICENSE_EXPIRED,
        LICENSE_USERS_LIMIT,
        LICENSE_TRIAL_VALID,
        LICENSE_WRONG_SERVERID,
        LICENSE_WRONG_APPKEY;

    }
}

