/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnectionConverter;
import com.atlassian.pocketknife.api.querydsl.configuration.ConfigurationEnrichment;
import com.atlassian.pocketknife.internal.querydsl.DatabaseConnectionConverterImpl;
import com.atlassian.pocketknife.internal.querydsl.cache.PKQCacheClearer;
import com.atlassian.pocketknife.internal.querydsl.dialect.DefaultDialectConfiguration;
import com.atlassian.pocketknife.internal.querydsl.schema.DatabaseSchemaCreation;
import com.atlassian.pocketknife.internal.querydsl.schema.JdbcTableInspector;
import com.atlassian.pocketknife.internal.querydsl.schema.ProductSchemaProvider;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import de.accxia.apps.confluence.ium.repository.AccxiaDefaultSchemaProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@ConfluenceComponent
public class AccxiaDatabaseAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaDatabaseAccessor.class);
    @ComponentImport
    private final DataSourceProvider dataSourceProvider;
    @ComponentImport
    private final ActiveObjects activeObjects;
    private final DatabaseConnectionConverter databaseConnectionConverter;
    private final DatabaseSchemaCreation databaseSchemaCreation;
    private final TransactionalExecutorFactory transactionalExecutorFactory;

    @Inject
    public AccxiaDatabaseAccessor(@Qualifier(value="dataSourceProvider") DataSourceProvider dataSourceProvider, ConfigurationEnrichment configurationEnrichment, JdbcTableInspector tableInspector, PKQCacheClearer cacheClearer, DatabaseSchemaCreation databaseSchemaCreation, ProductSchemaProvider productSchemaProvider, ActiveObjects activeObjects, TransactionalExecutorFactory transactionalExecutorFactory) {
        this.dataSourceProvider = dataSourceProvider;
        this.activeObjects = activeObjects;
        this.databaseSchemaCreation = databaseSchemaCreation;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        DefaultDialectConfiguration dialectProvider = new DefaultDialectConfiguration(new AccxiaDefaultSchemaProvider(new AccxiaProductSchemaProvider(transactionalExecutorFactory), tableInspector, cacheClearer), configurationEnrichment);
        this.databaseConnectionConverter = new DatabaseConnectionConverterImpl(dialectProvider);
    }

    public <T> T run(Function<DatabaseConnection, T> function) {
        this.databaseSchemaCreation.prime();
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor(false, false);
        try {
            return (T)executor.execute(jdbcConnection -> {
                DatabaseConnection connection = this.databaseConnectionConverter.convertExternallyManaged(jdbcConnection);
                return function.apply(connection);
            });
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> T run2(Function<DatabaseConnection, T> function) {
        this.databaseSchemaCreation.prime();
        return (T)this.activeObjects.executeInTransaction(() -> {
            DataSource dataSource = this.dataSourceProvider.getDataSource();
            try {
                Object retVal;
                Connection jdbcConnection = dataSource.getConnection();
                try {
                    DatabaseConnection connection = this.databaseConnectionConverter.convertExternallyManaged(jdbcConnection);
                    retVal = function.apply(connection);
                }
                catch (Throwable e) {
                    LOG.error("Exception " + e.getMessage(), e);
                    throw e;
                }
                finally {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable e) {
                            LOG.error("Exception " + e.getMessage(), e);
                        }
                    }
                }
                return retVal;
            }
            catch (SQLException var18) {
                throw new RuntimeException(var18);
            }
        });
    }

    class AccxiaProductSchemaProvider
    extends ProductSchemaProvider {
        private final TransactionalExecutorFactory executorFactory;

        public AccxiaProductSchemaProvider(TransactionalExecutorFactory executorFactory) {
            super(executorFactory);
            this.executorFactory = executorFactory;
        }

        @Override
        public Optional<String> getProductSchema() {
            return Optional.ofNullable((String)this.executorFactory.createReadOnly().getSchemaName().getOrNull());
        }
    }
}

