/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMClusterJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/job")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobRestController.class);
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private static LocalThread localThread = null;

    @Inject
    public JobRestController(MonitorJobRunner monitorJobRunner, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository, HelperTrialProcessing helperTrialProcessing) {
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMClusterJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMClusterJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMClusterJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMClusterJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMClusterJob.class)) {
            map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob(IUMClusterJob.class) != null ? this.monitorJobRunner.getLastRunForJob(IUMClusterJob.class).toString() : "N/A");
            map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob(IUMClusterJob.class) != null ? this.monitorJobRunner.getLastSuccessfulRunForJob(IUMClusterJob.class).toString() : "N/A");
            map.put("nextRunDate", this.monitorJobRunner.getNextRunDate(IUMClusterJob.class) != null ? this.monitorJobRunner.getNextRunDate(IUMClusterJob.class).toString() : "N/A");
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMJobData(), IUMClusterJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            long duration = Long.parseLong(DAO.getRemovalInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("inactivity_interval", Long.valueOf(duration));
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            IUMClusterJob.getInstance().injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    public void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ConfluenceUser currentUser;
        List<ProcessResult> processResultList = null;
        long elapsedTime;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ConfluenceUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobRestController.localThread.isWorking = true;
                IUMClusterJob.getInstance().injectService(JobRestController.this.helperTrialProcessing, JobRestController.this.helperService, JobRestController.this.iumHelperCacheService, JobRestController.this.jobResultRepository);
                List<ProcessResult> processResultList = IUMClusterJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                this.elapsedTime = stopTime - startTime;
                JobRestController.localThread.processResultList = processResultList;
                JobRestController.this.doSaveProcessResultList(processResultList, this.parameters, this.elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobRestController.localThread.isWorking = false;
            }
        }
    }
}

