/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import de.accxia.apps.confluence.ium.servlet.filter.AccxiaUserSessionTracker;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AccessLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);
    private final AccxiaUserSessionTracker accxiaUserSessionTracker;

    @Inject
    public AccessLogFilter(AccxiaUserSessionTracker accxiaUserSessionTracker) {
        this.accxiaUserSessionTracker = accxiaUserSessionTracker;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            try {
                this.accxiaUserSessionTracker.recordInteraction(httpServletRequest, httpServletResponse);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

