/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.content.render.xhtml.ResettableXmlEventReader;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.XMLEventFactoryProvider;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.content.render.xhtml.storage.inlinetask.StorageInlineTaskConstants;
import com.atlassian.confluence.content.render.xhtml.storage.resource.identifiers.StorageResourceIdentifierConstants;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;

@Named
public class IUMMentionsExcerptor {
    private static final QName USERKEY_ATTRIBUTE_QNAME = new QName("http://atlassian.com/resource/identifier", "userkey", "ri");
    private static final QName PARAGRAPH_QNAME = new QName("http://www.w3.org/1999/xhtml", "p");
    private static final QName LI_QNAME = new QName("http://www.w3.org/1999/xhtml", "li");
    private static final QName TR_QNAME = new QName("http://www.w3.org/1999/xhtml", "tr");
    private static final Set<QName> UNIT_ELEMENTS = Sets.newHashSet((Object[])new QName[]{PARAGRAPH_QNAME, LI_QNAME, TR_QNAME, StorageInlineTaskConstants.TASK_ELEMENT});
    private static final Set<QName> LIST_ELEMENTS = Sets.newHashSet((Object[])new QName[]{new QName("http://www.w3.org/1999/xhtml", "ol"), new QName("http://www.w3.org/1999/xhtml", "ul"), StorageInlineTaskConstants.TASK_LIST_ELEMENT});
    private static final Map<QName, String> DIVIDERS = new HashMap<QName, String>();
    private final XmlEventReaderFactory xmlEventReaderFactory = (XmlEventReaderFactory)ComponentLocator.getComponent(XmlEventReaderFactory.class);
    private final XmlOutputFactory xmlFragmentOutputFactory = (XmlOutputFactory)ComponentLocator.getComponent(XmlOutputFactory.class);
    private final XMLEventFactory xmlEventFactory;

    public IUMMentionsExcerptor() {
        XMLEventFactoryProvider xmlEventFactoryProvider = (XMLEventFactoryProvider)ComponentLocator.getComponent(XMLEventFactoryProvider.class);
        this.xmlEventFactory = xmlEventFactoryProvider.getXmlEventFactory();
    }

    public String getExcerpt(ContentEntityObject content, ConfluenceUser mentionedUser) {
        block5: {
            List<String> excerpts;
            if (mentionedUser == null || StringUtils.isBlank((CharSequence)mentionedUser.getName()) || content == null) break block5;
            BodyContent bodyContent = content.getBodyContent();
            if (bodyContent.getBodyType() != BodyType.XHTML) {
                return "";
            }
            XMLEventReader reader = null;
            try {
                reader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader("<div>" + bodyContent.getBody() + "</div>"));
                excerpts = this.getExcerpts(reader, mentionedUser);
            }
            catch (XMLStreamException var10) {
                try {
                    throw new RuntimeException("Error occurred while reading stream", var10);
                }
                catch (Throwable throwable) {
                    StaxUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            StaxUtils.closeQuietly((XMLEventReader)reader);
            StringBuilder result = new StringBuilder();
            Objects.requireNonNull(result);
            excerpts.forEach(result::append);
            return result.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getExcerpts(XMLEventReader xmlFragment, ConfluenceUser user) throws XMLStreamException {
        if (xmlFragment != null && xmlFragment.peek() != null) {
            List<String> excerptsUnitElements;
            if (!xmlFragment.peek().isStartElement()) {
                throw new IllegalArgumentException("xmlFragmentReader should serve start element of the fragment first.");
            }
            try {
                StartElement xmlFragmentStart = xmlFragment.peek().asStartElement();
                if (UNIT_ELEMENTS.contains(xmlFragmentStart.getName())) {
                    List<String> excerptsUnitElements2;
                    List<String> list = excerptsUnitElements2 = this.getExcerptsUnitElements(xmlFragmentStart, xmlFragment, user);
                    return list;
                }
                if (!LIST_ELEMENTS.contains(xmlFragmentStart.getName())) {
                    List<String> excerptsUnitElements3;
                    if ("table".equals(xmlFragmentStart.getName().getLocalPart())) {
                        List<String> excerptsUnitElements4;
                        List<String> list = excerptsUnitElements4 = this.getExcerptsTableElement(xmlFragment, user);
                        return list;
                    }
                    List<String> list = excerptsUnitElements3 = this.getExcerptsOtherElements(xmlFragment, user);
                    return list;
                }
                excerptsUnitElements = this.getExcerptsListElements(xmlFragmentStart, xmlFragment, user);
            }
            finally {
                StaxUtils.closeQuietly((XMLEventReader)xmlFragment);
            }
            return excerptsUnitElements;
        }
        return Collections.emptyList();
    }

    private List<String> getExcerptsUnitElements(StartElement xmlFragmentStart, XMLEventReader xmlEventReader, ConfluenceUser user) throws XMLStreamException {
        ResettableXmlEventReader xmlFragment = new ResettableXmlEventReader(xmlEventReader);
        if (this.fragmentContainsUser((XMLEventReader)xmlFragment, user)) {
            xmlFragment.reset();
            return Collections.singletonList(this.toStringBuilder((XMLEventReader)xmlFragment));
        }
        String divider = DIVIDERS.get(xmlFragmentStart.getName());
        return Collections.singletonList(divider == null ? "" : divider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getExcerptsListElements(StartElement xmlFragmentStart, XMLEventReader xmlFragment, ConfluenceUser user) throws XMLStreamException {
        LinkedList<String> excerpts = new LinkedList<String>();
        XMLEventReader xmlFragmentBody = this.xmlEventReaderFactory.createXmlFragmentBodyEventReader(xmlFragment);
        while (xmlFragmentBody.hasNext()) {
            XMLEvent xmlEvent = xmlFragmentBody.peek();
            if (xmlEvent.isStartElement() && UNIT_ELEMENTS.contains(xmlEvent.asStartElement().getName())) {
                XMLEventReader unitFragment = this.xmlEventReaderFactory.createXmlFragmentEventReader(xmlFragmentBody);
                Stream<String> var10000 = this.getExcerpts(unitFragment, user).stream().filter(excerpt -> excerpt != excerpts.peekLast() && !"".contentEquals((CharSequence)excerpt));
                Objects.requireNonNull(excerpts);
                var10000.forEach(excerpts::add);
                continue;
            }
            xmlFragmentBody.nextEvent();
        }
        if (excerpts.isEmpty()) {
            return Collections.emptyList();
        }
        StringWriter listFragmentBuffer = new StringWriter();
        XMLEventWriter listFragment = this.xmlFragmentOutputFactory.createXMLEventWriter((Writer)listFragmentBuffer);
        try {
            listFragment.add(xmlFragmentStart);
            listFragment.add(this.xmlEventFactory.createCharacters(""));
            listFragment.flush();
            excerpts.add(0, listFragmentBuffer.getBuffer().toString());
            int position = listFragmentBuffer.getBuffer().length();
            listFragment.add(xmlFragment.nextEvent());
            listFragment.flush();
            excerpts.add(listFragmentBuffer.getBuffer().substring(position, listFragmentBuffer.getBuffer().length()));
        }
        finally {
            StaxUtils.closeQuietly((XMLEventWriter)listFragment);
        }
        return excerpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getExcerptsTableElement(XMLEventReader xmlFragment, ConfluenceUser user) throws XMLStreamException {
        LinkedList<String> excerpts = new LinkedList<String>();
        LinkedList<XMLEvent> tableEvents = new LinkedList<XMLEvent>();
        tableEvents.add(xmlFragment.nextEvent());
        while (xmlFragment.hasNext()) {
            XMLEvent xmlEvent = xmlFragment.peek();
            if (xmlEvent.isStartElement() && "tr".equals(xmlEvent.asStartElement().getName().getLocalPart())) {
                XMLEventReader trFragment = this.xmlEventReaderFactory.createXmlFragmentEventReader(xmlFragment);
                Stream<String> var10000 = this.getExcerpts(trFragment, user).stream().filter(excerpt -> excerpt != excerpts.peekLast() && !"".contentEquals((CharSequence)excerpt));
                Objects.requireNonNull(excerpts);
                var10000.forEach(excerpts::add);
                continue;
            }
            tableEvents.add(xmlFragment.nextEvent());
        }
        if (excerpts.isEmpty()) {
            return Collections.emptyList();
        }
        StringWriter tableFragmentBuffer = new StringWriter();
        XMLEventWriter tableFragment = this.xmlFragmentOutputFactory.createXMLEventWriter((Writer)tableFragmentBuffer);
        try {
            Iterator var7 = tableEvents.iterator();
            while (var7.hasNext()) {
                XMLEvent tableEvent = (XMLEvent)var7.next();
                if (tableEvent.isStartElement() && "tbody".equals(tableEvent.asStartElement().getName().getLocalPart())) {
                    tableFragment.add(tableEvent);
                    tableFragment.add(this.xmlEventFactory.createCharacters(""));
                    tableFragment.flush();
                    continue;
                }
                tableFragment.add(tableEvent);
            }
        }
        finally {
            StaxUtils.closeQuietly((XMLEventWriter)tableFragment);
        }
        StringBuffer strBuffer = tableFragmentBuffer.getBuffer();
        int indexEndTbody = strBuffer.indexOf(">", strBuffer.indexOf("<tbody")) + 1;
        excerpts.add(0, tableFragmentBuffer.getBuffer().substring(0, indexEndTbody));
        excerpts.add(tableFragmentBuffer.getBuffer().substring(indexEndTbody, tableFragmentBuffer.getBuffer().length()));
        return excerpts;
    }

    private List<String> getExcerptsOtherElements(XMLEventReader xmlFragment, ConfluenceUser user) throws XMLStreamException {
        xmlFragment.nextEvent();
        LinkedList<String> excerpts = new LinkedList<String>();
        while (xmlFragment.hasNext()) {
            XMLEvent xmlFragmentEvent = xmlFragment.peek();
            if (xmlFragmentEvent.isStartElement()) {
                Stream<String> var10000 = this.getExcerpts(this.xmlEventReaderFactory.createXmlFragmentEventReader(xmlFragment), user).stream().filter(excerpt -> excerpt != excerpts.peekLast());
                Objects.requireNonNull(excerpts);
                var10000.forEach(excerpts::add);
                continue;
            }
            xmlFragment.nextEvent();
        }
        return excerpts;
    }

    private boolean fragmentContainsUser(XMLEventReader xmlFragmentReader, ConfluenceUser user) throws XMLStreamException {
        while (xmlFragmentReader.hasNext()) {
            Attribute userKeyAttribute;
            StartElement startElement;
            XMLEvent xmlEvent = xmlFragmentReader.nextEvent();
            if (!xmlEvent.isStartElement() || !(startElement = xmlEvent.asStartElement()).getName().equals(StorageResourceIdentifierConstants.USER_RESOURCE_QNAME) || (userKeyAttribute = startElement.getAttributeByName(USERKEY_ATTRIBUTE_QNAME)) == null || user.getKey() == null || !user.getKey().getStringValue().equals(userKeyAttribute.getValue())) continue;
            return true;
        }
        return false;
    }

    private String toStringBuilder(XMLEventReader xmlFragmentReader) {
        XMLEventWriter xmlEventWriter = null;
        StringWriter result = new StringWriter();
        try {
            xmlEventWriter = this.xmlFragmentOutputFactory.createXMLEventWriter((Writer)result);
            xmlEventWriter.add(xmlFragmentReader);
        }
        catch (XMLStreamException var8) {
            try {
                throw new RuntimeException(var8);
            }
            catch (Throwable throwable) {
                StaxUtils.closeQuietly(xmlEventWriter);
                throw throwable;
            }
        }
        StaxUtils.closeQuietly((XMLEventWriter)xmlEventWriter);
        return result.toString();
    }

    static {
        DIVIDERS.put(PARAGRAPH_QNAME, "<p style=\"text-align: left\">&middot;&middot;&middot;</p>");
    }
}

