/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.cache.AbstractCachedManager;
import de.accxia.apps.confluence.ium.cache.PropertyCacheEntryAdapter;
import de.accxia.apps.confluence.ium.config.DAO;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@Named(value="PropertyCachedManager")
public class PropertyCachedManager
extends AbstractCachedManager<String> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCachedManager.class);
    private Cache<String, String> cache = null;
    private PropertyCacheEntryAdapter<String> propertyCacheEntryAdapter;

    @Inject
    public PropertyCachedManager(@Qualifier(value="PropertyCacheEntryAdapter") PropertyCacheEntryAdapter<String> propertyCacheEntryAdapter, @ComponentImport ClusterManager clusterManager, @ComponentImport CacheManager cacheManager, @ComponentImport ApplicationContext applicationContext) {
        super(propertyCacheEntryAdapter, clusterManager, cacheManager, applicationContext);
        this.propertyCacheEntryAdapter = propertyCacheEntryAdapter;
    }

    @Override
    protected void doInit(CacheEntryListener<String, String> cacheEntryListener) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call PropertyCachedManager doInit ");
        }
        this.cache = this.getCacheManager().getCache(DAO.class.getName() + ".property2.cache", null, new CacheSettingsBuilder().remote().maxEntries(1000).unflushable().replicateAsynchronously().replicateViaCopy().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cache.addListener(this.getCacheEntryListener(), true);
    }

    @Override
    public void cleanup() {
        this.cache.removeListener(this.propertyCacheEntryAdapter);
    }

    public String getKeyValue(String key) {
        if (this.getCache() == null) {
            LOG.info("GET Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return null;
        }
        String value = (String)this.cache.get((Object)key);
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + (value != null ? value : "N/A"));
        }
        return value;
    }

    public String setKeyValue(String key, String value) {
        if (this.getCache() == null) {
            LOG.info("SET Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + value);
        }
        this.cache.put((Object)key, (Object)value);
        return (String)this.cache.get((Object)key);
    }

    public void deleteKey(String key) {
        if (this.getCache() == null) {
            LOG.info("DELETE Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE Cache[" + this.cache.getName() + "][" + this.getClusterName() + "] key=" + key);
        }
        this.cache.remove((Object)key);
    }

    public Map<String, String> getValues() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        if (this.getCache() == null) {
            LOG.info("GET Cache=NULL[" + this.getClusterName() + "]");
            return retVal;
        }
        for (String key : this.cache.getKeys()) {
            String cacheValue = (String)this.cache.get((Object)key);
            if (LOG.isTraceEnabled()) {
                LOG.info("GET Cache[" + this.cache.getName() + "][" + this.getClusterName() + "]" + (cacheValue == null ? "" : cacheValue));
            }
            retVal.put(key, cacheValue);
        }
        return retVal;
    }

    public boolean deleteValues() {
        if (this.getCache() == null) {
            LOG.info("DELETE Cache=NULL[" + this.getClusterName() + "]");
            return false;
        }
        this.cache.removeAll();
        return true;
    }

    private Cache<String, String> getCache() {
        if (this.cache == null) {
            LOG.info("RECREATE Cache=NULL[" + this.getClusterName() + "]");
            this.doInit((CacheEntryListener<String, String>)this.propertyCacheEntryAdapter);
        }
        return this.cache;
    }
}

