/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMWatcherJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.Mutex;
import de.accxia.apps.confluence.ium.model.JobResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.Constants;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobWatchService.class})
@Named(value="JobWatchService")
public class JobWatchService {
    private static final Logger LOG = LoggerFactory.getLogger(JobWatchService.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final JobResultRepository jobResultRepository;

    @Inject
    public JobWatchService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, IUMHelperService helperService, LocalNotificationService notificationService) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.helperService = helperService;
        this.notificationService = notificationService;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobWatchService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMWatcherJobData(), IUMWatcherJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobWatchService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMWatcherJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMWatcherJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMWatcherJob.class);
    }

    public void updateLastRunTime(long timestamp) {
        this.monitorJobRunner.updateLastRunTime(IUMWatcherJob.class, timestamp);
    }

    public Date calculateNextRunTime() {
        return this.monitorJobRunner.calculateNextRunTime(IUMWatcherJob.class, 0L);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMWatcherJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(new String[]{"LevelJob"}, idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPreparation() {
        boolean locked = false;
        try {
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            if (locked) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Future retVal = executorService.submit(new Callable(){

                    public Boolean call() throws Exception {
                        return JobWatchService.this.doLocalRunPreparation();
                    }
                });
                LOG.info("WatchService run #[" + SDF.format(new Date()) + "] ");
            }
        }
        catch (Exception e) {
            LOG.error("WatchService Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doLocalRunPreparation() {
        boolean locked = false;
        try {
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            if (locked) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WatchService Process #[" + SDF.format(new Date()) + "] ");
                }
                long watcherInactivityDuration = JobData.DEFAULT_USER_INACTIVITY_SHORT_INTERVAL;
                UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
                GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
                String enableGroups = DAO.getIUMGroups();
                String disableGroups = DAO.getIUMGroupsDisabled();
                int removalUserExpected = Constants.EPAM_LICENSE;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WatchService Process with groups={} interval={} removalUserExpected={} at date={} ", new Object[]{enableGroups, watcherInactivityDuration, removalUserExpected, SDF.format(new Date())});
                }
                if (StringUtils.isEmpty((CharSequence)enableGroups)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("WatchService skip empty group #[" + SDF.format(new Date()) + "] ");
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                long refTS = System.currentTimeMillis() - watcherInactivityDuration;
                String[] eGroups = enableGroups.split(",");
                String[] dGroups = disableGroups.split(",");
                long timeExpectedToEnd = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(4L);
                boolean timeLimitReached = false;
                for (int i = 0; i < eGroups.length; ++i) {
                    int removed = 0;
                    String enableGroup = eGroups[i];
                    String disableGroup = dGroups[i];
                    List<String> inactiveUsers = this.helperService.getInactiveUsers4EnabledGroups(enableGroup, disableGroup, refTS, 0, removalUserExpected);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("WatchService group={} inactiveUsers={} refTS={}/{} ", new Object[]{enableGroup, inactiveUsers.size(), refTS, SDF.format(new Date(refTS))});
                    }
                    try {
                        Group group = groupManager.getGroup(enableGroup);
                        for (String userName : inactiveUsers) {
                            try {
                                TimeUnit.MILLISECONDS.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                LOG.error("InterruptedException: " + e.getMessage(), (Throwable)e);
                            }
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("IUMWatcherJob process user={}", (Object)userName);
                                }
                                this.helperService.doRemoveMembership2Group(group, userAccessor.getUserByName(userName));
                                ++removed;
                            }
                            catch (Exception e) {
                                LOG.error("EntityException: " + e.getMessage(), (Throwable)e);
                            }
                            if (System.currentTimeMillis() <= timeExpectedToEnd) continue;
                            LOG.debug("IUMWatcherJob Processed exceed time ={} ", new Object[]{timeExpectedToEnd});
                            timeLimitReached = true;
                            break;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("IUMWatcherJob Processed groups={} removed={} interval={} at [ {} ] ", new Object[]{enableGroups, removed, watcherInactivityDuration, SDF.format(new Date())});
                        continue;
                    }
                    catch (EntityException e) {
                        LOG.error("EntityException " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            Boolean watcherInactivityDuration = Boolean.TRUE;
            return watcherInactivityDuration;
        }
        catch (Exception e) {
            LOG.error("IUMWatcherJob Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
        return Boolean.FALSE;
    }
}

