/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.JobAccessService;
import de.accxia.apps.confluence.ium.job.JobClusterService;
import de.accxia.apps.confluence.ium.job.JobDailyEventService;
import de.accxia.apps.confluence.ium.job.JobDailyService;
import de.accxia.apps.confluence.ium.job.JobLicenseService;
import de.accxia.apps.confluence.ium.job.JobMembershipService;
import de.accxia.apps.confluence.ium.job.JobSyncService;
import de.accxia.apps.confluence.ium.job.JobWatchService;
import de.accxia.apps.confluence.ium.util.Constants;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
public class IUMListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(IUMListener.class);
    public static Boolean PLUGIN_ENABLED = false;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final DAO dao;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService helperCacheService;
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;
    private final JobDailyService jobDailyService;
    private final JobDailyEventService jobDailyEventService;
    private final JobWatchService jobWatchService;
    private final JobLicenseService jobLicenseService;
    private final JobAccessService jobAccessService;
    private final JobMembershipService jobMembershipService;

    @Inject
    public IUMListener(EventPublisher eventPublisher, JobSyncService jobSyncService, JobClusterService jobClusterService, JobWatchService jobWatchService, JobLicenseService jobLicenseService, JobAccessService jobAccessService, UserAccessor userAccessor, IUMHelperService helperService, JobDailyService jobDailyService, DAO dao, IUMHelperCacheService helperCacheService, JobDailyEventService jobDailyEventService, JobMembershipService jobMembershipService) {
        this.eventPublisher = eventPublisher;
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.jobDailyService = jobDailyService;
        this.jobWatchService = jobWatchService;
        this.jobLicenseService = jobLicenseService;
        this.userAccessor = userAccessor;
        this.dao = dao;
        this.helperService = helperService;
        this.jobAccessService = jobAccessService;
        this.helperCacheService = helperCacheService;
        this.jobDailyEventService = jobDailyEventService;
        this.jobMembershipService = jobMembershipService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        PLUGIN_ENABLED = true;
        ConditionEvaluatorIUMImpl.setSideLicense();
        if ("on".equalsIgnoreCase(DAO.getSyncWorkingJob()) && !this.jobSyncService.isWorking()) {
            this.jobSyncService.restart();
        }
        if ("on".equalsIgnoreCase(DAO.getWorkingJob()) && !this.jobClusterService.isWorking()) {
            this.jobClusterService.restart();
        }
        if (!this.jobDailyService.isWorking()) {
            this.jobDailyService.start();
        }
        if (!this.jobDailyEventService.isWorking()) {
            this.jobDailyEventService.start();
        }
        if ("on".equalsIgnoreCase(DAO.getWatcherJob()) && !this.jobWatchService.isWorking()) {
            this.jobWatchService.start();
        }
        if (!this.jobLicenseService.isWorking()) {
            this.jobLicenseService.start();
        }
        if (!this.jobAccessService.isWorking()) {
            this.jobAccessService.start();
        }
        if (!this.jobMembershipService.isWorking()) {
            this.jobMembershipService.start();
        }
        if (Constants.EPAM) {
            this.jobWatchService.runPreparation();
        }
    }

    public void destroy() throws Exception {
        DAO.propertyCachedManager.cleanup();
        this.eventPublisher.unregister((Object)this);
        try {
            if (this.jobSyncService.isWorking()) {
                this.jobSyncService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception jobSyncService " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobClusterService.isWorking()) {
                this.jobClusterService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception jobClusterService " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception jobDailyService " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyEventService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception jobDailyEventService " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobWatchService.isWorking()) {
                this.jobWatchService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception jobWatchService " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobLicenseService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception jobLicenseService " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobAccessService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception jobAccessService " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobMembershipService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception jobMembershipService " + e.getMessage(), (Throwable)e);
        }
        this.helperCacheService.removeAllCache();
        PLUGIN_ENABLED = false;
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        String userName = logoutEvent.getUsername();
        if (ConditionEvaluatorIUMImpl.isLicenseValid() && logoutEvent.getExplicitLogout()) {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            this.helperService.moveUserToDisabled(user);
        }
    }
}

