/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.event.events.space.SpacePermissionsUpdateEvent;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.job.access.IntentRemoveAccess;
import de.accxia.apps.confluence.ium.servlet.filter.AccxiaResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class GatekeeperFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GatekeeperFilter.class);
    @ComponentImport
    private final CacheManager cacheManager;
    @ComponentImport
    private final ClusterManager clusterManager;
    @ConfluenceImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    private final AccxiaAccessMap accxiaAccessMap;
    private static final Map<String, String> JOB_MAP = new HashMap<String, String>();
    private static final Map<String, List<IntentRemoveAccess>> REMOVE_ACCESS_MAP = new HashMap<String, List<IntentRemoveAccess>>();
    private static Cache<String, Object> cache = null;

    public GatekeeperFilter(UserAccessor userAccessor, CacheManager cacheManager, ClusterManager clusterManager, EventPublisher eventPublisher, UserManager userManager, GroupManager groupManager, AccxiaAccessMap accxiaAccessMap, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager) {
        this.userAccessor = userAccessor;
        this.cacheManager = cacheManager;
        this.clusterManager = clusterManager;
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.accxiaAccessMap = accxiaAccessMap;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("GatekeeperFilter RequestURI=" + httpServletRequest.getRequestURI());
        }
        try {
            if (httpServletRequest.getMethod().equalsIgnoreCase("POST") && (httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/space/init-evaluator.action") || httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/global/init-evaluator.action"))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GatekeeperFilter doFilter init-evaluator.action process=" + httpServletRequest.getRequestURI());
                }
                String userFilter = httpServletRequest.getParameter("userFilter");
                String spaceFilter = httpServletRequest.getParameter("spaceFilter");
                if (userFilter == null && userFilter.isEmpty()) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                String[] users = userFilter.split(",");
                String[] spaces = spaceFilter.split(",");
                String[] disabledGroups = DAO.getIUMGroupsDisabled().split(",");
                String[] enabledGroups = DAO.getIUMGroups().split(",");
                List disableGroupList = Arrays.stream(disabledGroups).map(g -> {
                    try {
                        return this.groupManager.getGroup(g);
                    }
                    catch (EntityException e) {
                        return null;
                    }
                }).collect(Collectors.toList());
                List enabledGroupList = Arrays.stream(enabledGroups).map(g -> {
                    try {
                        return this.groupManager.getGroup(g);
                    }
                    catch (EntityException e) {
                        return null;
                    }
                }).collect(Collectors.toList());
                List<Space> spaceList = Arrays.stream(spaces).map(s -> this.spaceManager.getSpace(s)).collect(Collectors.toList());
                boolean processing = false;
                for (String user : users) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Process user={}", (Object)user);
                    }
                    User checkUser = this.userManager.getUser(user);
                    for (int k = 0; k < disableGroupList.size(); ++k) {
                        List<Space> spaceSublist;
                        if (disableGroupList.get(k) == null || enabledGroupList.get(k) == null || !this.groupManager.hasMembership((Group)disableGroupList.get(k), checkUser) || this.groupManager.hasMembership((Group)enabledGroupList.get(k), checkUser) || (spaceSublist = this.hasGroupPermission((Group)enabledGroupList.get(k), spaceList)).size() == 0) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Process spaceSublist size={}", (Object)spaceSublist.size());
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Process user= {} add to group={}", (Object)user, (Object)((Group)enabledGroupList.get(k)).getName());
                        }
                        this.accxiaAccessMap.remove(user);
                        IntentRemoveAccess intentRemoveAccess = new IntentRemoveAccess(enabledGroups[k], disabledGroups[k]);
                        if (!REMOVE_ACCESS_MAP.containsKey(user)) {
                            REMOVE_ACCESS_MAP.put(user, new ArrayList());
                        }
                        REMOVE_ACCESS_MAP.get(user).add(intentRemoveAccess);
                        this.userAccessor.addMembership((Group)enabledGroupList.get(k), checkUser);
                        processing = true;
                        if (LOG.isDebugEnabled()) {
                            boolean hasMembership = this.userAccessor.hasMembership((Group)enabledGroupList.get(k), checkUser);
                            LOG.debug("Added user= {} add to {} hasMembership {}", new Object[]{user, ((Group)enabledGroupList.get(k)).getName(), Boolean.toString(hasMembership)});
                        }
                        for (Space space : spaceList) {
                            SpacePermission viewPermission = SpacePermission.createGroupSpacePermission((String)"VIEWSPACE", (Space)space, (String)((Group)enabledGroupList.get(k)).getName());
                            this.eventPublisher.publish((Object)new SpacePermissionsUpdateEvent((Object)this, space));
                        }
                    }
                }
                if (processing) {
                    this.spacePermissionManager.flushCaches();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    AccxiaResponseWrapper servletResponseWrapper = new AccxiaResponseWrapper(httpServletResponse);
                    filterChain.doFilter(servletRequest, (ServletResponse)servletResponseWrapper);
                    try {
                        String body = servletResponseWrapper.getCaptureAsString();
                        JsonNode jsonNode = GatekeeperFilter.toJSONValid(body);
                        if (jsonNode.has("jobId")) {
                            JOB_MAP.put(jsonNode.get("jobId").asText(), userFilter);
                        }
                        servletResponse.getOutputStream().write(servletResponseWrapper.getCachedContent());
                    }
                    catch (Exception e) {
                        for (String user : users) {
                            this.accxiaAccessMap.add(user);
                        }
                        servletResponse.getOutputStream().write(servletResponseWrapper.getCachedContent());
                    }
                    return;
                }
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("GET") && (httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/space/permissions.action") || httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/global/permissions.action"))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GatekeeperFilter doFilter permissions.action process=" + httpServletRequest.getRequestURI());
                }
                filterChain.doFilter(servletRequest, servletResponse);
                String jobId = httpServletRequest.getParameter("jobId");
                String userFilter = JOB_MAP.get(jobId);
                if (userFilter != null && !userFilter.isEmpty()) {
                    String[] users;
                    for (String user : users = userFilter.split(",")) {
                        List<IntentRemoveAccess> intentRemoveAccesses = REMOVE_ACCESS_MAP.get(user);
                        if (intentRemoveAccesses != null && intentRemoveAccesses.size() > 0) {
                            intentRemoveAccesses.stream().forEach(x -> {
                                try {
                                    this.userAccessor.removeMembership(this.groupManager.getGroup(x.getEnableGroups()), (User)this.userAccessor.getUserByName(user));
                                }
                                catch (EntityException e) {
                                    LOG.error("EntityException " + e.getMessage(), (Throwable)e);
                                }
                            });
                        }
                        REMOVE_ACCESS_MAP.remove(user);
                    }
                }
                JOB_MAP.remove(jobId);
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("GET") && (httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/space/explain.action") || httpServletRequest.getRequestURI().endsWith("/plugins/gatekeeper-plugin/global/explain.action"))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GatekeeperFilter doFilter explain.action process=" + httpServletRequest.getRequestURI());
                }
                String type = httpServletRequest.getParameter("type");
                String username = httpServletRequest.getParameter("username");
                String spaceKey = httpServletRequest.getParameter("spaceKey");
                if (!"user".equalsIgnoreCase(type) || username == null || spaceKey == null) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                User checkUser = this.userManager.getUser(username);
                String[] disabledGroups = DAO.getIUMGroupsDisabled().split(",");
                String[] enabledGroups = DAO.getIUMGroups().split(",");
                List disableGroupList = Arrays.stream(disabledGroups).map(g -> {
                    try {
                        return this.groupManager.getGroup(g);
                    }
                    catch (EntityException e) {
                        return null;
                    }
                }).collect(Collectors.toList());
                List enabledGroupList = Arrays.stream(enabledGroups).map(g -> {
                    try {
                        return this.groupManager.getGroup(g);
                    }
                    catch (EntityException e) {
                        return null;
                    }
                }).collect(Collectors.toList());
                boolean processing = false;
                ArrayList<IntentRemoveAccess> removeAccesses = new ArrayList<IntentRemoveAccess>();
                try {
                    for (int k = 0; k < disableGroupList.size(); ++k) {
                        if (disableGroupList.get(k) == null || enabledGroupList.get(k) == null || !this.groupManager.hasMembership((Group)disableGroupList.get(k), checkUser) || this.groupManager.hasMembership((Group)enabledGroupList.get(k), checkUser)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Process user= {} add to group={}", (Object)username, (Object)((Group)enabledGroupList.get(k)).getName());
                        }
                        this.accxiaAccessMap.remove(username);
                        IntentRemoveAccess intentRemoveAccess = new IntentRemoveAccess(enabledGroups[k], disabledGroups[k]);
                        removeAccesses.add(intentRemoveAccess);
                        this.userAccessor.addMembership((Group)enabledGroupList.get(k), checkUser);
                        processing = true;
                    }
                    if (processing) {
                        this.spacePermissionManager.flushCaches();
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    filterChain.doFilter(servletRequest, servletResponse);
                    if (processing) {
                        removeAccesses.stream().forEach(x -> {
                            try {
                                this.userAccessor.removeMembership(this.groupManager.getGroup(x.getEnableGroups()), (User)this.userAccessor.getUserByName(username));
                            }
                            catch (EntityException e) {
                                LOG.error("EntityException " + e.getMessage(), (Throwable)e);
                            }
                        });
                    }
                    return;
                }
                catch (Exception e) {
                    this.accxiaAccessMap.add(username);
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private List<Space> hasGroupPermission(Group group, List<Space> spaceList) {
        ArrayList<Space> retVal = new ArrayList<Space>();
        for (Space space : spaceList) {
            Map mapGroups = this.spacePermissionManager.getGroupsForPermissionType("VIEWSPACE", space);
            long findCount = mapGroups.keySet().stream().filter(g -> g.equals(group.getName())).count();
            if (findCount <= 0L) continue;
            retVal.add(space);
        }
        return retVal;
    }

    public void destroy() {
    }

    public static JsonNode toJSONValid(String jsonInString) {
        if (StringUtils.isEmpty((CharSequence)jsonInString)) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonInString);
        }
        catch (IOException ex) {
            LOG.error(" " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private Cache<String, Object> getCache() {
        if (cache == null) {
            cache = this._getCache((CacheFactory)this.cacheManager);
        }
        return cache;
    }

    private Cache<String, Object> _getCache(CacheFactory cacheFactory) {
        CacheSettings cacheSettings = new CacheSettingsBuilder().unflushable().remote().replicateViaCopy().replicateSynchronously().expireAfterWrite(5L, TimeUnit.MINUTES).maxEntries(100000).build();
        return cacheFactory.getCache("com.atlassian.confluence.plugins.gatekeeper.evaluator.cache", (CacheLoader)null, cacheSettings);
    }
}

