/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.authorisation;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.config.DAO;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IUMFilterAuthorisation
implements Filter {
    private static Log LOGGER = LogFactory.getLog(IUMFilterAuthorisation.class);
    private final UserManager userManager;
    private final UserAccessor userAccessor;

    @Inject
    public IUMFilterAuthorisation(UserManager userManager, UserAccessor userAccessor) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String username;
        LOGGER.debug((Object)"doFilter called...");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (httpServletRequest.getSession() != null && !StringUtils.isBlank((CharSequence)(username = (String)httpServletRequest.getSession().getAttribute("seraph_defaultauthenticator_user_id"))) && !this.skipUrl(httpServletRequest).booleanValue() && this.isUserInGroups(username, DAO.getIUMGroupsDisabled())) {
            httpServletRequest.setAttribute("os_authstatus", (Object)"success");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String getCurrentLoggedInUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return confluenceUser == null ? "" : confluenceUser.getName();
    }

    private Boolean skipUrl(HttpServletRequest httpServletRequest) {
        String url = httpServletRequest.getRequestURL().toString();
        return url.matches("(.*)/plugins/servlet/login(.*)") || url.matches("(.*)/plugins/servlet/saml/auth(.*)") || url.matches("(.*)plugins/servlet/saml/logout(.*)") || url.matches("(.*)batch.css(.*)") || url.matches("(.*)batch.js(.*)") || url.matches("(.*)login.js(.*)") || url.matches("(.*)adgs-icons.ttf(.*)") || url.matches("(.*)plugins/servlet/saml/getconfig(.*)") || url.matches("(.*)plugins/servlet/saml/moapi(.*)") || url.matches("(.*)plugins/servlet/saml/metadata(.*)") || url.matches("(.*)/rest(.*)") || url.matches("(.*)forgotuserpassword.action(.*)") || url.matches("(.*)doforgotuserpassword.action(.*)") || url.matches("(.*)resetuserpassword.action(.*)") || url.matches("(.*)signup.action(.*)") || url.matches("(.*)/plugins/servlet/secureshare/accesslink(.*)") || url.matches("(.*)/images/logo/(.*)") || url.matches("(.*)/oauth/consumer-info(.*)") || url.matches("(.*)/plugins/servlet/capabilities(.*)") || url.matches("(.*)/plugins/servlet/usersync(.*)") || url.matches("(.*)/oauth/access-token(.*)") || url.matches("(.*)/oauth/request-token(.*)") || url.matches("(.*)com.atlassian.auiplugin(.*)") || url.matches("(.*)entrypoint-login-page-ui.css(.*)") || url.matches("(.*)entrypoint-login-page-ui.js(.*)") || url.matches("(.*)data-collector-async.js(.*)") || url.matches("(.*)/jcaptcha(.*)") || url.matches("(.*)/aboutconfluence(.*)") || url.matches("(.*)/com.atlassian.plugins.authentication(.*)") || url.matches("(.*)com.atlassian.confluence.plugins(.*)");
    }

    protected boolean isUserInGroups(String userName, String groupNames) {
        if (groupNames == null || "".equals(groupNames)) {
            return false;
        }
        List groups = this.userAccessor.getGroupNamesForUserName(userName);
        if (groups != null) {
            for (String g : groupNames.split(",")) {
                if (!groups.contains(g.trim())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("IsUserInGroupsConditionBase user " + userName + " is in groups=" + groupNames));
                }
                return true;
            }
        }
        return false;
    }
}

