/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AccxiaResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream capture;
    private ServletOutputStream output;
    private PrintWriter writer;
    private String redirLocation = "";

    public AccxiaResponseWrapper(HttpServletResponse response) {
        super(response);
        this.capture = new ByteArrayOutputStream(response.getBufferSize());
        this.output = new CachedServletOutputStream();
    }

    public ServletOutputStream getOutputStream() {
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)this.output, true);
        }
        return this.writer;
    }

    public byte[] getCachedContent() {
        return this.capture.toByteArray();
    }

    public String getCaptureAsString() throws IOException {
        return new String(this.getCachedContent(), this.getCharacterEncoding());
    }

    public void sendRedirect(String location) throws IOException {
        this.redirLocation = location;
    }

    public String getRedirectLocation() throws IOException {
        return this.redirLocation;
    }

    private class CachedServletOutputStream
    extends ServletOutputStream {
        private CachedServletOutputStream() {
        }

        public void write(int b) throws IOException {
            AccxiaResponseWrapper.this.capture.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            AccxiaResponseWrapper.this.capture.write(b, off, len);
        }

        public void flush() throws IOException {
            AccxiaResponseWrapper.this.capture.flush();
        }

        public void close() throws IOException {
            AccxiaResponseWrapper.this.capture.close();
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

