/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.JobClusterService;
import de.accxia.apps.confluence.ium.job.JobDailyEventService;
import de.accxia.apps.confluence.ium.job.JobSyncService;
import de.accxia.apps.confluence.ium.job.JobWatchService;
import java.lang.reflect.Field;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="PropertyCacheEntryAdapter")
public class PropertyCacheEntryAdapter<V>
implements CacheEntryListener<String, V> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCacheEntryAdapter.class);
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;
    private final JobWatchService jobWatchService;
    private final JobDailyEventService jobDailyEventService;

    @Inject
    public PropertyCacheEntryAdapter(JobClusterService jobClusterService, JobSyncService jobSyncService, JobWatchService jobWatchService, JobDailyEventService jobDailyEventService) {
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.jobWatchService = jobWatchService;
        this.jobDailyEventService = jobDailyEventService;
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (!(cacheEntryEvent.getKey() instanceof String) || !(cacheEntryEvent.getValue() instanceof String)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onAdd " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onEvict " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onRemove " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        String workingWatcherJob;
        String workingJob;
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " new=" + cacheEntryEvent.getValue().getClass().getName());
        }
        String value = this.extractValueFromEntryEvent(cacheEntryEvent);
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingJob") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingJob = value;
            try {
                if ("on".equalsIgnoreCase(workingJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobClusterService.isWorking());
                    }
                    if (this.jobClusterService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobClusterService " + new Date());
                        this.jobClusterService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobClusterService " + new Date());
                    this.jobClusterService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=OFF isWorking=" + this.jobClusterService.isWorking());
                    }
                    if (this.jobClusterService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobClusterService " + new Date());
                        this.jobClusterService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("removalCronExpression") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("interval") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("startingFrom") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingJob = value;
            try {
                if (value != null && this.jobClusterService.isWorking()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobClusterService.isWorking());
                    }
                    this.jobClusterService.stop();
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobClusterService " + new Date());
                    this.jobClusterService.start();
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingSyncJob") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String workingSyncJob = value;
            try {
                if ("on".equalsIgnoreCase(workingSyncJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob=ON isWorking=" + this.jobSyncService.isWorking());
                    }
                    if (this.jobSyncService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobSyncService " + new Date());
                        this.jobSyncService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start jobSyncService " + new Date());
                    this.jobSyncService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob=OFF isWorking=" + this.jobSyncService.isWorking());
                    }
                    if (this.jobSyncService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobSyncService " + new Date());
                        this.jobSyncService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("syncCronExpression") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("syncRepeatInterval") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("syncStartingFrom") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("syncAllSrcGroup") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("syncAllTargetGroup") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingJob = value;
            try {
                if (value != null && this.jobSyncService.isWorking()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobSyncService.isWorking());
                    }
                    this.jobSyncService.stop();
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobClusterService " + new Date());
                    this.jobSyncService.start();
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("watcherJob") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingWatcherJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingWatcherJob = value;
            try {
                if ("on".equalsIgnoreCase(workingWatcherJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingWatcherJob=ON isWorking=" + this.jobWatchService.isWorking());
                    }
                    if (this.jobWatchService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobWatchService " + new Date());
                        this.jobWatchService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start jobSyncService " + new Date());
                    this.jobWatchService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingWatcherJob=OFF isWorking=" + this.jobWatchService.isWorking());
                    }
                    if (this.jobWatchService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobWatchService " + new Date());
                        this.jobWatchService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("watcherInactivityDuration") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("watcherGroupLevel") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("watcherRemovalCount") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingWatcherJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingWatcherJob = value;
            try {
                if (value != null && this.jobWatchService.isWorking()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobWatchService.isWorking());
                    }
                    this.jobWatchService.stop();
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobClusterService " + new Date());
                    this.jobWatchService.start();
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingDailyJob") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive dailyWorkingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String dailyWorkingJob = value;
            try {
                if ("on".equalsIgnoreCase(dailyWorkingJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive dailyWorkingJob=ON isWorking=" + this.jobDailyEventService.isWorking());
                    }
                    if (this.jobDailyEventService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobDailyEventService " + new Date());
                        this.jobDailyEventService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start jobDailyEventService " + new Date());
                    this.jobDailyEventService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive dailyWorkingJob=OFF isWorking=" + this.jobDailyEventService.isWorking());
                    }
                    if (this.jobDailyEventService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobDailyEventService " + new Date());
                        this.jobDailyEventService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("dailyCronExpression") && value != null || ((String)cacheEntryEvent.getKey()).equalsIgnoreCase("dailyStartingFrom") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive dailyWorkingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            workingJob = value;
            try {
                if (value != null && this.jobDailyEventService.isWorking()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive dailyWorkingJob=ON isWorking=" + this.jobDailyEventService.isWorking());
                    }
                    this.jobDailyEventService.stop();
                    LOG.warn("[PropertyCacheEntryAdapter] Start jobDailyEventService " + new Date());
                    this.jobDailyEventService.start();
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense") && value != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + value);
            }
            String sideLicense = value;
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private String extractValueFromEntryEvent(CacheEntryEvent<String, V> cacheEntryEvent) {
        if (cacheEntryEvent.getValue() instanceof String) {
            return (String)cacheEntryEvent.getValue();
        }
        if (cacheEntryEvent.getValue() == null) {
            return "";
        }
        Field field = null;
        try {
            field = FieldUtils.getField(cacheEntryEvent.getValue().getClass(), (String)"value", (boolean)true);
            field.setAccessible(true);
            String str = field.get(cacheEntryEvent.getValue()) == null ? "" : field.get(cacheEntryEvent.getValue()).toString();
            return str;
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            return "";
        }
    }
}

