/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.webresource.api.QueryParams;
import de.accxia.apps.confluence.ium.conditions.BaseCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAdministratorCondition
extends BaseCondition {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceAdministratorCondition.class);
    private static final String ADMIN_ENABLED_PARAM = "admin-enabled";
    private final PermissionManager permissionManager;

    public ConfluenceAdministratorCondition(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected boolean isConditionTrue() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConfluenceAdministratorCondition check user=" + user.getName());
        }
        return this.permissionManager.isConfluenceAdministrator(user);
    }

    @Override
    public boolean shouldDisplay(QueryParams queryParams) {
        return this.isConditionTrue();
    }
}

