/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.AlertType;
import de.accxia.apps.confluence.ium.notif.IUMDailyReportManager;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.side.LicenseData;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMDailyEventJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyEventJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMDailyEventJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private IUMAlertRepository iumAlertRepository;
    private IUMDailyReportManager iumDailyReportManager;
    private HelperTrialProcessing helperTrialProcessing;
    int syncUsers = 0;

    private IUMDailyEventJob() {
    }

    public static IUMDailyEventJob getInstance() {
        if (instance == null) {
            instance = new IUMDailyEventJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Override
    public void injectService(IUMDailyReportManager iumDailyReportManager) {
        this.iumDailyReportManager = iumDailyReportManager;
    }

    @Override
    public void injectService(IUMAlertRepository iumAlertRepository) {
        this.iumAlertRepository = iumAlertRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyEventJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        int dailyEventFrom = -1;
        if (parameters.get("daily_event_from") != null) {
            dailyEventFrom = Integer.parseInt((String)((Object)parameters.get("daily_event_from")));
        }
        String sourceGroups = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyEventJob for groups = {} dailyEventFrom={}  at [ {} ] ", new Object[]{sourceGroups, dailyEventFrom, SDF.format(new Date())});
        }
        if (this.iumDailyReportManager != null && !StringUtils.isEmpty((CharSequence)sourceGroups)) {
            this.iumDailyReportManager.generateDailyReportsExemption(dailyEventFrom);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMDailyEventJob for groups = {}  done at [ {} ] ", new Object[]{sourceGroups, SDF.format(new Date())});
            }
            processResultList.add(new ProcessResult("DailyEventJob", sourceGroups, null));
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyEventJob iumDailyReportManager is NULL ?");
        }
        Date currentDate = new Date();
        LicenseData licenseData = ConditionEvaluatorIUMImpl.getSideLicense();
        if (licenseData != null && licenseData.getDueDate() != null) {
            long diffInMillies = licenseData.getDueDate().getTime() - currentDate.getTime();
            long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
            if (diff >= 0L && diff < 30L) {
                this.helperTrialProcessing.markLicenseExpireError(AlertType.ALERT_LICENSE_EXPIRE, diff);
            }
            if (diff < 0L) {
                this.helperTrialProcessing.markLicenseExpireError(AlertType.ALERT_LICENSE_EXPIRE, diff);
            }
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMDailyEventJob Processed #[" + SDF.format(new Date()) + "]");
        }
        return processResultList;
    }
}

