/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IUMDailyJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.model.JobResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ExportAsService(value={JobDailyService.class})
@Named(value="JobDailyService")
public class JobDailyService {
    private static final Log LOG = LogFactory.getLog(JobDailyService.class);
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final JobResultRepository jobResultRepository;

    @Inject
    public JobDailyService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, IUMHelperService helperService, LocalNotificationService notificationService) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.helperService = helperService;
        this.notificationService = notificationService;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobDailyService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMDailyJobData(), IUMDailyJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobDailyService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMDailyJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMDailyJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMDailyJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

