/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ehcache.EhCacheManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.sal.api.component.ComponentLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractCachedManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCachedManager.class);
    private ApplicationContext applicationContext;
    private CacheManager cacheManager;
    private ClusterManager clusterManager;
    protected CacheEntryListener<String, T> cacheEntryListener = null;

    public AbstractCachedManager(CacheEntryListener<String, T> cacheEntryListener, ClusterManager clusterManager, CacheManager cacheManager, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.cacheEntryListener = cacheEntryListener;
        Object object = this.clusterManager = clusterManager.isClustered() ? clusterManager : null;
        if (this.applicationContext == null) {
            throw new IllegalStateException("Error, possible  plugin should not start correct");
        }
        if (this.cacheEntryListener == null) {
            this.cacheEntryListener = (CacheEntryListener)applicationContext.getBean(CacheEntryListener.class);
        }
        this.doInit(cacheEntryListener);
    }

    private ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("Plugin does not start correct");
        }
        return this.applicationContext;
    }

    private <S> S getBean(Class<S> beanClazz) {
        try {
            return (S)ComponentLocator.getComponent(beanClazz);
        }
        catch (Exception e) {
            LOG.info("NoSuchBeanDefinitionException " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        this.cacheManager = this.getBean(CacheManager.class);
        if (this.cacheManager != null) {
            LOG.info("CacheManager - class " + this.cacheManager.getClass().getName());
            return this.cacheManager;
        }
        this.cacheManager = new EhCacheManager();
        LOG.info("CacheManager- class " + this.cacheManager.getClass().getName());
        return this.cacheManager;
    }

    public CacheEntryListener<String, T> getCacheEntryListener() {
        return this.cacheEntryListener;
    }

    protected String getClusterName() {
        try {
            if (this.clusterManager != null) {
                return this.clusterManager.getClusterInformation().getName();
            }
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
        }
        return "Node";
    }

    protected abstract void doInit(CacheEntryListener<String, T> var1);

    public abstract void cleanup();
}

