/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsCondition;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsConditionBase;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IsUserInGroupsCondition2
extends IsUserInGroupsConditionBase {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    private final IUMHelperCacheService iumHelperCacheService;

    @Inject
    public IsUserInGroupsCondition2(UserManager userManager, UserAccessor userAccessor, IUMHelperCacheService iumHelperCacheService) {
        super(userManager, userAccessor);
        this.iumHelperCacheService = iumHelperCacheService;
    }

    @Override
    public boolean shouldDisplay(QueryParams queryParams) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return queryParams.get("accxia-user") != null;
        }
        if (this.iumHelperCacheService != null) {
            if (this.iumHelperCacheService.isUserInDisableGroups(user)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IsUserInGroupsCondition user " + user.getName() + " is in groups=" + DAO.getIUMGroupsDisabled());
                }
                return true;
            }
            return false;
        }
        if (this.isUserInGroups(user.getName(), DAO.getIUMGroupsDisabled())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGroupsCondition user " + user.getName() + " is in groups=" + DAO.getIUMGroupsDisabled());
            }
            return true;
        }
        return false;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder) {
        ConfluenceUser user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Call IsUserInGroupsCondition");
        }
        if ((user = AuthenticatedUserThreadLocal.get()) != null) {
            urlBuilder.addToQueryString("accxia-user", user.getName());
        }
        urlBuilder.addToHash("_", (Object)String.valueOf(System.currentTimeMillis()));
        urlBuilder.addToQueryString("gc-accxia", String.valueOf(System.currentTimeMillis()));
    }
}

