/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import de.accxia.apps.confluence.ium.cache.PropertyCachedManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="DAO")
public class DAO {
    private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    private static final String MYUNIQUENAME = "IUM4Confluence";
    public static final String REST_ROUTE = "urlRest";
    public static final String REST_INIT = "initRest";
    public static final String RESERVED_LICENSE = "reservedLicense";
    public static final String INACTIVITY_DURATION = "inactivityDuration";
    public static final String REMOVAL_INACTIVITY_DURATION = "removalInactivityDuration";
    public static final String REPEAT_INTERVAL = "interval";
    public static final String STARTING_AT = "startingAt";
    public static final String STARTING_FROM = "startingFrom";
    public static final String REMOVAL_CRON_EXPRESSION = "removalCronExpression";
    public static final String SYNC_REPEAT_INTERVAL = "syncRepeatInterval";
    public static final String SYNC_STARTING_FROM = "syncStartingFrom";
    public static final String SYNC_CRON_EXPRESSION = "syncCronExpression";
    public static final String SYNC_STARTING_AT = "syncStartingAt";
    public static final String SYNC_ALL_SRC_GROUP = "syncAllSrcGroup";
    public static final String SYNC_ALL_TARGET_GROUP = "syncAllTargetGroup";
    public static final String WATCHER_REPEAT_INTERVAL = "watcherRepeatInterval";
    public static final String WATCHER_INACTIVITY_DURATION = "watcherInactivityDuration";
    public static final String WATCHER_GROUP_LEVEL = "watcherGroupLevel";
    public static final String WATCHER_REMOVAL_COUNT = "watcherRemovalCount";
    public static final String WATCHER_JOB = "watcherJob";
    public static final String WORKING_JOB = "workingJob";
    public static final String WORKING_SYNC_JOB = "workingSyncJob";
    public static final String AUTO_CONNECT = "autoConnect";
    public static final String LOGGER = "logger";
    public static final String LOGGER_KEY = "de.accxia.apps.confluence.ium";
    public static final String DAILY_STARTING_FROM = "dailyStartingFrom";
    public static final String DAILY_REPEAT_INTERVAL = "dailyRepeatInterval";
    public static final String DAILY_CRON_EXPRESSION = "dailyCronExpression";
    public static final String WORKING_DAILY_JOB = "workingDailyJob";
    public static final String SYNC_LICENSE_INTERVAL = "syncLicenseInterval";
    private static PluginSettings settings = null;
    public static PropertyCachedManager propertyCachedManager;

    @Inject
    public DAO(PropertyCachedManager propertyCachedManager) {
        DAO.propertyCachedManager = propertyCachedManager;
    }

    public static void loadSettings(PluginSettings settings) {
        DAO.settings = settings;
        DAO.getValueByKey("sideLicense");
        DAO.getValueByKey("IUMGroup");
        DAO.getValueByKey("IUMGroupDIS");
        DAO.getValueByKey("duration");
        DAO.getValueByKey("queueSize");
        DAO.getValueByKey("samlIdp");
        DAO.getValueByKey("samlMapping");
        DAO.getValueByKey("samlRegex");
        DAO.getValueByKey("fromGroup");
        DAO.getValueByKey("toGroup");
        DAO.getValueByKey(WATCHER_REPEAT_INTERVAL);
        DAO.getValueByKey(WATCHER_GROUP_LEVEL);
        DAO.getValueByKey(WATCHER_REMOVAL_COUNT);
        DAO.getValueByKey(WATCHER_JOB);
        DAO.getValueByKey(SYNC_CRON_EXPRESSION);
        DAO.getValueByKey(DAILY_STARTING_FROM);
        DAO.getValueByKey(DAILY_REPEAT_INTERVAL);
        DAO.getValueByKey(DAILY_CRON_EXPRESSION);
        DAO.getValueByKey(WORKING_DAILY_JOB);
    }

    public static PluginSettings getSettings() {
        return settings;
    }

    private static String emptyValueFromNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getValueByKey(String field) {
        if (propertyCachedManager == null) {
            Object value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL");
            }
            if ((value = settings.get("IUM4Confluence." + field)) == null) {
                value = "";
                settings.put("IUM4Confluence." + field, (Object)"");
            }
            if ("null".equals(value)) {
                return null;
            }
            String res = String.valueOf(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL field={} value={}", new Object[]{field, res});
            }
            return DAO.emptyValueFromNull(res);
        }
        String ourVal = propertyCachedManager.getKeyValue(field);
        if (ourVal == null) {
            Object value = settings.get("IUM4Confluence." + field);
            String res = String.valueOf(value);
            if (res == null || "null".equals(res)) {
                res = "";
                settings.put("IUM4Confluence." + field, (Object)res);
            }
            propertyCachedManager.setKeyValue(field, res);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager field={} value={}", new Object[]{field, res});
            }
            return DAO.emptyValueFromNull(res);
        }
        if (ourVal == null || !ourVal.equals(settings.get("IUM4Confluence." + field))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager update field={} value={}", new Object[]{field, ourVal});
            }
            settings.put("IUM4Confluence." + field, (Object)ourVal);
        }
        return DAO.emptyValueFromNull(ourVal);
    }

    public static String setValue(String field, String value) {
        if (value == null || !value.equals(DAO.getValueByKey(field))) {
            settings.put("IUM4Confluence." + field, (Object)value);
            if (propertyCachedManager != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DAO.propertyCachedManager setValue field={} value={}", new Object[]{field, value});
                }
                propertyCachedManager.setKeyValue(field, value);
            }
        }
        return value;
    }

    public static void updateSideLicense(String value) {
        DAO.setValue("sideLicense", value);
    }

    public static String getSideLicense() {
        String sideLicense = DAO.getValueByKey("sideLicense");
        return sideLicense == null ? "" : sideLicense;
    }

    public static void updateIUMGroup(String value) {
        DAO.setValue("IUMGroup", value);
    }

    public static String getIUMGroups() {
        String IUMGroup2 = DAO.getValueByKey("IUMGroup");
        return IUMGroup2 == null ? "" : IUMGroup2;
    }

    public static void updateIUMGroupDisabled(String value) {
        DAO.setValue("IUMGroupDIS", value);
    }

    public static String getIUMGroupsDisabled() {
        String IUMGroupDIS = DAO.getValueByKey("IUMGroupDIS");
        return IUMGroupDIS == null ? "" : IUMGroupDIS;
    }

    public static void updateDuration(String value) {
        DAO.setValue("duration", value);
    }

    public static String getDuration() {
        String duration = DAO.getValueByKey("duration");
        return duration == null ? "" : duration;
    }

    public static void updateQueueSize(String value) {
        DAO.setValue("queueSize", value);
    }

    public static String getQueueSize() {
        String queueSize = DAO.getValueByKey("queueSize");
        return queueSize == null ? "" : queueSize;
    }

    public static void updateUrlLogo(String value) {
        DAO.setValue("urlLogo", value);
    }

    public static String getUrlLogo() {
        return DAO.getValueByKey("urlLogo");
    }

    public static void updateHeightLogo(String value) {
        DAO.setValue("heightLogo", value);
    }

    public static String getHeightLogo() {
        return DAO.getValueByKey("heightLogo");
    }

    public static void updateQueueMessage(String value) {
        DAO.setValue("queueMessage", value);
    }

    public static String getQueueMessage() {
        return DAO.getValueByKey("queueMessage");
    }

    public static void updateTempDisconnectMessage(String value) {
        DAO.setValue("tempDisconnect", value);
    }

    public static String getTempDisconnectMessage() {
        return DAO.getValueByKey("tempDisconnect");
    }

    public static void updateUrlRest(String value) {
        DAO.setValue(REST_ROUTE, value);
    }

    public static String getUrlRest() {
        return DAO.getValueByKey(REST_ROUTE);
    }

    public static void updateSamlIdp(String value) {
        DAO.setValue("samlIdp", value);
    }

    public static String getSamlIdp() {
        String samlIdp = DAO.getValueByKey("samlIdp");
        return samlIdp == null ? "" : samlIdp;
    }

    public static void updateSamlMapping(String value) {
        DAO.setValue("samlMapping", value);
    }

    public static String getSamlMapping() {
        String samlMapping = DAO.getValueByKey("samlMapping");
        return samlMapping == null ? "" : samlMapping;
    }

    public static void updateSamlRegex(String value) {
        DAO.setValue("samlRegex", value);
    }

    public static String getSamlRegex() {
        String samlRegex = DAO.getValueByKey("samlRegex");
        return samlRegex == null ? "" : samlRegex;
    }

    public static String getReservedLicense() {
        String reservedLicense = DAO.getValueByKey(RESERVED_LICENSE);
        if (reservedLicense == null || "".equals(reservedLicense)) {
            reservedLicense = String.valueOf(3);
            DAO.updateReservedLicense(reservedLicense);
        }
        return reservedLicense;
    }

    public static void updateReservedLicense(String value) {
        DAO.setValue(RESERVED_LICENSE, value);
    }

    public static String getInactivityDuration() {
        String inactivityDuration = DAO.getValueByKey(INACTIVITY_DURATION);
        if (inactivityDuration == null || "".equals(inactivityDuration)) {
            inactivityDuration = "5";
            DAO.updateInactivityDuration(inactivityDuration);
        }
        return inactivityDuration;
    }

    public static void updateInactivityDuration(String value) {
        DAO.setValue(INACTIVITY_DURATION, value);
    }

    public static String getRepeatInterval() {
        return DAO.getValueByKey(REPEAT_INTERVAL);
    }

    public static void updateRepeatInterval(String value) {
        DAO.setValue(REPEAT_INTERVAL, value);
    }

    public static void updateStartingAt(String value) {
        DAO.setValue(STARTING_AT, value);
    }

    public static String getStartingAt() {
        return DAO.getValueByKey(STARTING_AT);
    }

    public static void updateStartingFrom(String value) {
        DAO.setValue(STARTING_FROM, value);
    }

    public static String getStartingFrom() {
        return DAO.getValueByKey(STARTING_FROM);
    }

    public static void updateRemovalCronExpression(String value) {
        DAO.setValue(REMOVAL_CRON_EXPRESSION, value);
    }

    public static String getRemovalCronExpression() {
        return DAO.getValueByKey(REMOVAL_CRON_EXPRESSION);
    }

    public static String getRemovalInactivityDuration() {
        String removalInactivityDuration = DAO.getValueByKey(REMOVAL_INACTIVITY_DURATION);
        if (removalInactivityDuration == null || "".equals(removalInactivityDuration)) {
            removalInactivityDuration = "5";
            DAO.updateInactivityDuration(removalInactivityDuration);
        }
        return removalInactivityDuration;
    }

    public static void updateRemovalInactivityDuration(String value) {
        DAO.setValue(REMOVAL_INACTIVITY_DURATION, value);
    }

    public static void updateWorkingJob(String value) {
        DAO.setValue(WORKING_JOB, value);
    }

    public static String getWorkingJob() {
        return DAO.getValueByKey(WORKING_JOB);
    }

    public static void updateSyncAllSrcGoups(String value) {
        DAO.setValue(SYNC_ALL_SRC_GROUP, value);
    }

    public static String getSyncAllSrcGoups() {
        String IUMGroup2 = DAO.getValueByKey(SYNC_ALL_SRC_GROUP);
        return IUMGroup2;
    }

    public static void updateSyncAllTargetGoups(String value) {
        DAO.setValue(SYNC_ALL_TARGET_GROUP, value);
    }

    public static String getSyncAllTargetGoups() {
        String IUMGroupDIS = DAO.getValueByKey(SYNC_ALL_TARGET_GROUP);
        return IUMGroupDIS;
    }

    public static String getSyncRepeatInterval() {
        String repeatInterval = DAO.getValueByKey(SYNC_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateSyncRepeatInterval(String value) {
        DAO.setValue(SYNC_REPEAT_INTERVAL, value);
    }

    public static void updateSyncStartingAt(String value) {
        DAO.setValue(SYNC_STARTING_AT, value);
    }

    public static String getSyncStartingAt() {
        return DAO.getValueByKey(SYNC_STARTING_AT);
    }

    public static void updateSyncStartingFrom(String value) {
        DAO.setValue(SYNC_STARTING_FROM, value);
    }

    public static String getSyncStartingFrom() {
        return DAO.getValueByKey(SYNC_STARTING_FROM);
    }

    public static void updateSyncCronExpression(String value) {
        DAO.setValue(SYNC_CRON_EXPRESSION, value);
    }

    public static String getSyncCronExpression() {
        return DAO.getValueByKey(SYNC_CRON_EXPRESSION);
    }

    public static void updateSyncWorkingJob(String value) {
        DAO.setValue(WORKING_SYNC_JOB, value);
    }

    public static String getSyncWorkingJob() {
        return DAO.getValueByKey(WORKING_SYNC_JOB);
    }

    public static String getWatcherInactivityDuration() {
        String watcherInactivityDuration = DAO.getValueByKey(WATCHER_INACTIVITY_DURATION);
        return watcherInactivityDuration;
    }

    public static void updateWatcherInactivityDuration(String value) {
        DAO.setValue(WATCHER_INACTIVITY_DURATION, value);
    }

    public static String getWatcherGroupLevel() {
        String watcherGroupLevel = DAO.getValueByKey(WATCHER_GROUP_LEVEL);
        return watcherGroupLevel;
    }

    public static void updateWatcherGroupLevel(String value) {
        DAO.setValue(WATCHER_GROUP_LEVEL, value);
    }

    public static String getWatcherRemovalCount() {
        String watcherGroupLevel = DAO.getValueByKey(WATCHER_REMOVAL_COUNT);
        return watcherGroupLevel;
    }

    public static void updateWatcherRemovalCount(String value) {
        DAO.setValue(WATCHER_REMOVAL_COUNT, value);
    }

    public static String getWatcherJob() {
        String watcherJob = DAO.getValueByKey(WATCHER_JOB);
        return watcherJob;
    }

    public static void updateWatcherJob(String value) {
        DAO.setValue(WATCHER_JOB, value);
    }

    public static String getAutoConnect() {
        String autoConnect = DAO.getValueByKey(AUTO_CONNECT);
        return autoConnect;
    }

    public static boolean getAutoConnectAsBool() {
        String autoConnect = DAO.getValueByKey(AUTO_CONNECT);
        return "on".equals(autoConnect);
    }

    public static void updateAutoConnect(String value) {
        DAO.setValue(AUTO_CONNECT, value);
    }

    public static String getDailyRepeatInterval() {
        String repeatInterval = DAO.getValueByKey(DAILY_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateDailyRepeatInterval(String value) {
        DAO.setValue(DAILY_REPEAT_INTERVAL, value);
    }

    public static String getDailyStartingFrom() {
        String repeatInterval = DAO.getValueByKey(DAILY_STARTING_FROM);
        return repeatInterval;
    }

    public static void updateDailyStartingFrom(String value) {
        DAO.setValue(DAILY_STARTING_FROM, value);
    }

    public static String getDailyCronExpression() {
        String dailyCronExpression = DAO.getValueByKey(DAILY_CRON_EXPRESSION);
        return dailyCronExpression;
    }

    public static void updateDailyCronExpression(String value) {
        DAO.setValue(DAILY_CRON_EXPRESSION, value);
    }

    public static void updateDailyWorkingJob(String value) {
        DAO.setValue(WORKING_DAILY_JOB, value);
    }

    public static String getDailyWorkingJob() {
        return DAO.getValueByKey(WORKING_DAILY_JOB);
    }

    public static Boolean getLoggerLevel() {
        String logger = DAO.getValueByKey(LOGGER);
        return logger != null ? Boolean.valueOf(logger) : Boolean.FALSE;
    }

    public static void updateLoggerLevel(boolean value) {
        DAO.setValue(LOGGER, String.valueOf(value));
    }

    public static String getSyncLicenseInterval() {
        String syncLicenseInterval = DAO.getValueByKey(SYNC_LICENSE_INTERVAL);
        return syncLicenseInterval;
    }

    public static void updateSyncLicenseInterval(String value) {
        DAO.setValue(SYNC_LICENSE_INTERVAL, value);
    }
}

