/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.model;

import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResult;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class JobResultDTO
implements Serializable {
    private Integer ID;
    private String process;
    String userName;
    long userCopied;
    long userRemoved;
    String sourceGroups;
    String targetGroup;
    String shortSourceGroups;
    String shortTargetGroup;
    Date startTime;
    Date endTime;
    long duration;
    String error;

    public static JobResultDTO fromAO(JobResult jobResult) {
        JobResultDTO jobResultDTO = new JobResultDTO();
        if (jobResult != null) {
            jobResultDTO.setID(jobResult.getID());
            jobResultDTO.setProcess(jobResult.getProcess());
            jobResultDTO.setUserName(jobResult.getUserName());
            jobResultDTO.setUserCopied(jobResult.getUserCopied());
            jobResultDTO.setUserRemoved(jobResult.getUserRemoved());
            jobResultDTO.setSourceGroups(jobResult.getSourceGroups());
            jobResultDTO.setTargetGroup(jobResult.getTargetGroup());
            jobResultDTO.setStartTime(jobResult.getStartTime());
            jobResultDTO.setEndTime(jobResult.getEndTime());
            jobResultDTO.setError(jobResult.getError());
            if (jobResultDTO.getEndTime() != null && jobResultDTO.getStartTime() != null) {
                jobResultDTO.setDuration(jobResultDTO.getEndTime().getTime() - jobResultDTO.getStartTime().getTime());
            }
        }
        return jobResultDTO;
    }

    public static JobResultDTO createJobResult(ProcessResult processResult, String currentUser, long elapsedTime) {
        JobResultDTO jobResultDTO = new JobResultDTO();
        Date startTime = new Date(processResult.getStartTimestamp());
        Date endTime = new Date(processResult.getStartTimestamp() + (processResult.getElapsedTime() > 0L ? processResult.getElapsedTime() : elapsedTime));
        if (processResult != null) {
            jobResultDTO.setUserName(currentUser);
            jobResultDTO.setProcess(processResult.getProcess());
            jobResultDTO.setUserCopied(processResult.getUserCopied());
            jobResultDTO.setUserRemoved(processResult.getUserRemoved());
            jobResultDTO.setSourceGroups(processResult.getSourceGroups());
            jobResultDTO.setTargetGroup(processResult.getTargetGroup());
            jobResultDTO.setStartTime(startTime);
            jobResultDTO.setEndTime(endTime);
            jobResultDTO.setError(processResult.getError());
            if (jobResultDTO.getEndTime() != null && jobResultDTO.getStartTime() != null) {
                jobResultDTO.setDuration(jobResultDTO.getEndTime().getTime() - jobResultDTO.getStartTime().getTime());
            }
        }
        return jobResultDTO;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getUserCopied() {
        return this.userCopied;
    }

    public void setUserCopied(long userCopied) {
        this.userCopied = userCopied;
    }

    public long getUserRemoved() {
        return this.userRemoved;
    }

    public void setUserRemoved(long userRemoved) {
        this.userRemoved = userRemoved;
    }

    public String getSourceGroups() {
        return this.sourceGroups;
    }

    public void setSourceGroups(String sourceGroups) {
        this.sourceGroups = sourceGroups;
    }

    public String getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getShortSourceGroups() {
        return this.shortSourceGroups;
    }

    public void setShortSourceGroups(String shortSourceGroups) {
        this.shortSourceGroups = shortSourceGroups;
    }

    public String getShortTargetGroup() {
        return this.shortTargetGroup;
    }

    public void setShortTargetGroup(String shortTargetGroup) {
        this.shortTargetGroup = shortTargetGroup;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobResultDTO)) {
            return false;
        }
        JobResultDTO that = (JobResultDTO)o;
        return this.userCopied == that.userCopied && this.userRemoved == that.userRemoved && this.duration == that.duration && Objects.equals(this.ID, that.ID) && Objects.equals(this.process, that.process) && Objects.equals(this.userName, that.userName) && Objects.equals(this.sourceGroups, that.sourceGroups) && Objects.equals(this.targetGroup, that.targetGroup) && Objects.equals(this.shortSourceGroups, that.shortSourceGroups) && Objects.equals(this.shortTargetGroup, that.shortTargetGroup) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.ID);
        result = 31 * result + Objects.hashCode(this.process);
        result = 31 * result + Objects.hashCode(this.userName);
        result = 31 * result + Long.hashCode(this.userCopied);
        result = 31 * result + Long.hashCode(this.userRemoved);
        result = 31 * result + Objects.hashCode(this.sourceGroups);
        result = 31 * result + Objects.hashCode(this.targetGroup);
        result = 31 * result + Objects.hashCode(this.shortSourceGroups);
        result = 31 * result + Objects.hashCode(this.shortTargetGroup);
        result = 31 * result + Objects.hashCode(this.startTime);
        result = 31 * result + Objects.hashCode(this.endTime);
        result = 31 * result + Long.hashCode(this.duration);
        result = 31 * result + Objects.hashCode(this.error);
        return result;
    }

    public String toString() {
        return "JobResultDTO{ID=" + this.ID + ", userName='" + this.userName + "', userCopied=" + this.userCopied + ", userRemoved=" + this.userRemoved + ", sourceGroups='" + this.sourceGroups + "', targetGroup='" + this.targetGroup + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", error='" + this.error + "'}";
    }
}

