/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.GroupSearchResultEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SearchResultEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SearchResultEntityList;
import com.atlassian.confluence.plugins.rest.jackson2.service.SearchServiceException;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.UserSearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.model.Link;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.accxia.apps.confluence.ium.config.AbstractResource;
import de.accxia.apps.confluence.ium.config.model.UserSearchResults;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/search")
@Component
public class SearchService
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);
    public static final int LIMIT = 100;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final SearchManager searchManager;
    @ComponentImport
    private final PredefinedSearchBuilder predefinedSearchBuilder;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final SettingsManager settingsManager;

    @Inject
    public SearchService(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, SearchManager searchManager, PredefinedSearchBuilder predefinedSearchBuilder, CrowdService crowdService, SettingsManager settingsManager) {
        super(userAccessor, spacePermissionManager);
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
        this.searchManager = searchManager;
        this.predefinedSearchBuilder = predefinedSearchBuilder;
        this.crowdService = crowdService;
        this.settingsManager = settingsManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user")
    public Response searchUser(@QueryParam(value="cql") String query, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            this.createRequestContext();
            Integer max = limit < 100 ? 100 : limit;
            SearchResults searchResults = this.userSearch(query, max);
            UserSearchResults userSearchResults = UserSearchResults.buildFrom(searchResults);
            if (searchResults.size() < limit) {
                String startingWith = this.extractStartingWith(query);
                List<com.atlassian.crowd.embedded.api.User> userList = this.findUserStartingWith(startingWith);
                Map<String, ConfluenceUser> mapConfluenceUser = userList.stream().filter(user -> user != null && user.getName() != null).collect(Collectors.toMap(u -> u.getName(), u -> this.userAccessor.getUserByName(u.getName())));
                UserSearchResults userSearchResults2 = UserSearchResults.buildFrom(userList, mapConfluenceUser);
                userSearchResults = UserSearchResults.combineSearchResults(userSearchResults, userSearchResults2);
            }
            return Response.ok((Object)userSearchResults).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/userc")
    public Response searchUserContributor(@QueryParam(value="cql") String query, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            this.createRequestContext();
            Integer max = limit < 100 ? 100 : limit;
            SearchResults searchResults = this.userSearch(query, max);
            UserSearchResults userSearchResults = UserSearchResults.buildFrom(searchResults);
            if (searchResults.size() < limit) {
                String startingWith = this.extractStartingWith(query);
                if (startingWith.endsWith("*")) {
                    startingWith = startingWith.substring(0, startingWith.length() - 1);
                }
                List<com.atlassian.crowd.embedded.api.User> userList = this.findUserStartingWith(startingWith);
                Map<String, ConfluenceUser> mapConfluenceUser = userList.stream().collect(Collectors.toMap(u -> u.getName(), u -> this.userAccessor.getUserByName(u.getName())));
                Map<String, ProfilePictureInfo> mapProfileConfluenceUser = mapConfluenceUser.values().stream().collect(Collectors.toMap(u -> u.getName(), u -> this.userAccessor.getUserProfilePicture((User)u)));
                UserSearchResults userSearchResults2 = UserSearchResults.buildFrom(userList, mapConfluenceUser, mapProfileConfluenceUser);
                userSearchResults = UserSearchResults.combineSearchResults(userSearchResults, userSearchResults2);
            }
            return Response.ok((Object)userSearchResults).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user2")
    public Response searchUser(@QueryParam(value="query") String query, @QueryParam(value="max-results") int limit) {
        return this.searchUserOrGroup(query, 0, 100);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user-or-group")
    public Response searchUserOrGroup(@QueryParam(value="query") String query, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            this.createRequestContext();
            Integer max = limit < 100 ? 100 : limit;
            SearchResults searchResults = this.userSearch(query, max);
            List users = this.makeSearchResultsEntityList(searchResults).getResults();
            List groups = this.groupSearch(query, max).getResults();
            SearchResultEntityList combined = new SearchResultEntityList();
            combined.setResults((List)ImmutableList.copyOf(this.concatSearchResultEntity(users, groups)));
            return Response.ok((Object)combined).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private SearchResultEntityList makeSearchResultsEntityList(SearchResults searchResults) {
        List<SearchResultEntity> resultList = this.toSearchResultEntityList(searchResults);
        SearchResultEntityList list = new SearchResultEntityList();
        list.setResults(resultList);
        list.setTotalSize(searchResults.getUnfilteredResultsCount());
        return list;
    }

    private List<SearchResultEntity> toSearchResultEntityList(SearchResults searchResults) {
        ArrayList<SearchResultEntity> resultList = new ArrayList<SearchResultEntity>(searchResults.size());
        for (SearchResult r : searchResults) {
            SearchResultEntity resultEntity;
            if (r.getType() == null || (resultEntity = this.toSearchResultEntity(r)) == null) continue;
            resultList.add(resultEntity);
        }
        return resultList;
    }

    private SearchResultEntity toSearchResultEntity(SearchResult result) {
        UserSearchResultEntity userSearchResultEntity = new UserSearchResultEntity();
        try {
            userSearchResultEntity = userSearchResultEntity.build(result);
        }
        catch (URISyntaxException e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return userSearchResultEntity;
    }

    private <E> Iterable<E> concatSearchResultEntity(Iterable<E> users, List<E> groups) {
        return Iterables.concat(users, groups);
    }

    private SearchResults userSearch(String query, Integer maxResults) throws InvalidSearchException {
        UserSearchQueryParameters.Builder params = UserSearchQueryParameters.builder().query(query);
        params.addUserCategory(UserSearchQueryParameters.UserCategory.UNLICENSED);
        params.addUserCategory(UserSearchQueryParameters.UserCategory.LICENSED);
        ISearch usersSearch = this.predefinedSearchBuilder.buildUsersSearch(params.build(), 0, maxResults.intValue());
        SearchResults searchResults = this.searchManager.search(usersSearch);
        return searchResults;
    }

    public SearchResultEntityList groupSearch(String query, Integer maxResults) throws SearchServiceException {
        Integer maxim = maxResults == null || maxResults < 100 ? 100 : maxResults;
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        if (!StringUtils.isBlank((CharSequence)query)) {
            restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)query), Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true)});
        }
        GroupQuery crowdQuery = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, maxim.intValue());
        Iterable result = this.crowdService.search((Query)crowdQuery);
        ArrayList<GroupSearchResultEntity> resultList = new ArrayList<GroupSearchResultEntity>();
        for (Group group : result) {
            resultList.add(new GroupSearchResultEntity(group.getName()));
        }
        SearchResultEntityList resultEntities = new SearchResultEntityList();
        resultEntities.setResults(resultList);
        return resultEntities;
    }

    private List<com.atlassian.crowd.embedded.api.User> findUserStartingWith(String startingWith) {
        BooleanRestriction booleanRestriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)startingWith), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).startingWith((Object)startingWith), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)startingWith), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)startingWith)}), Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true)});
        EntityQuery findUsersQuery = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)booleanRestriction).returningAtMost(100);
        return StreamSupport.stream(this.crowdService.search((Query)findUsersQuery).spliterator(), false).map(u -> this.crowdService.getUser(u.getName())).collect(Collectors.toList());
    }

    private String extractStartingWith(String query) {
        Pattern pattern = Pattern.compile("\"(.*?)\"");
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public class UserSearchResultEntity
    extends ContentEntity {
        SearchResult result;

        public UserSearchResultEntity build(SearchResult result) throws URISyntaxException {
            this.setId(result.getField("handle"));
            this.setTitle(result.getField("title"));
            this.setType("user");
            this.setUserKey(new UserKey(result.getField("userKey")));
            this.setUsername(result.getField("username"));
            String url = result.getField("profile-picture-url");
            this.setThumbnailLink(Link.link((URI)new URI(SearchService.this.settingsManager.getGlobalSettings().getBaseUrl() + url), (String)"thumbnail", (String)"text/html"));
            String urlPath = result.getField("urlPath");
            this.addLink(Link.link((URI)new URI(SearchService.this.settingsManager.getGlobalSettings().getBaseUrl() + urlPath), (String)"alternate", (String)"text/html"));
            this.setWikiLink("[~" + result.getField("username") + "]");
            return this;
        }
    }
}

