/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.Mutex;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMClusterJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private HelperTrialProcessing helperTrialProcessing;

    private IUMClusterJob() {
    }

    public static IUMClusterJob getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessResult> doProcessingJob(final Map<String, Serializable> parameters) {
        boolean locked = false;
        try {
            List processResults;
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future retVal = executorService.submit(new Callable(){

                public List<ProcessResult> call() throws Exception {
                    return IUMClusterJob.this.doLocalProcessingJob(parameters);
                }
            });
            List list = processResults = (List)retVal.get();
            return list;
        }
        catch (Exception e) {
            this.LOG.error("IUMClusterJob Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
        return Collections.emptyList();
    }

    public List<ProcessResult> doLocalProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        String enableGroups = DAO.getIUMGroups();
        String disableGroups = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", enableGroups);
        if (StringUtils.isEmpty((CharSequence)enableGroups)) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("IUMClusterJob Empty enableGroup --> run at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return processResultList;
        }
        long refTS = System.currentTimeMillis() - inactivityInterval;
        processResult.setUserRemoved(0L);
        List<String> inactiveUsers = this.helperService.getInactiveUsers4EnabledGroups(refTS);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMClusterJob inactiveUsers={} refTS={}", (Object)inactiveUsers.size(), (Object)refTS);
        }
        for (String userName : inactiveUsers) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.helperService.removeUserFromGroup(userName, enableGroups);
            this.iumHelperCacheService.removeUserAccessFromCache(userName);
            this.iumHelperCacheService.addUserToRemovalCache(userName);
            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
        }
        this.iumHelperCacheService.removeGroupAccessFromCache(enableGroups);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResult.setElapsedTime(System.currentTimeMillis() - processResult.getStartTimestamp());
        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

