/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMWatcherJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/wjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class JobWatchRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobWatchRestController.class);
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private static LocalThread localThread = null;

    @Inject
    public JobWatchRestController(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, LocalNotificationService notificationService, HelperTrialProcessing helperTrialProcessing) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.notificationService = notificationService;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        JobData jobData = JobDataUtils.createWatcherJobData();
        map.put("repeat_interval", String.valueOf(jobData.getRepeatInterval()));
        map.put("starting_from", String.valueOf(jobData.getStartingFrom()));
        map.put("cron_expression", String.valueOf(jobData.getCronExpression()));
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMWatcherJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMWatcherJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMWatcherJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMWatcherJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMWatcherJob.class)) {
            RunDetails lastRunForJob = this.monitorJobRunner.getLastRunForJob(IUMWatcherJob.class);
            RunDetails lastSuccessfulRunForJob = this.monitorJobRunner.getLastSuccessfulRunForJob(IUMWatcherJob.class);
            Date nextRunDate = this.monitorJobRunner.getNextRunDate(IUMWatcherJob.class);
            Date nextRunDate10 = this.monitorJobRunner.calculateNextRunTime(IUMWatcherJob.class, jobData.getRepeatInterval() + TimeUnit.MINUTES.toMillis(10L));
            Date nextRunDate20 = this.monitorJobRunner.calculateNextRunTime(IUMWatcherJob.class, jobData.getRepeatInterval() + TimeUnit.MINUTES.toMillis(20L));
            Date nextRunDate30 = this.monitorJobRunner.calculateNextRunTime(IUMWatcherJob.class, jobData.getRepeatInterval() + TimeUnit.MINUTES.toMillis(30L));
            map.put("lastRunForJob", lastRunForJob != null ? lastRunForJob.toString() : "N/A");
            map.put("lastSuccessfulRunForJob", lastSuccessfulRunForJob != null ? lastSuccessfulRunForJob.toString() : "N/A");
            map.put("nextRunDate", nextRunDate != null ? nextRunDate.toString() : "N/A");
            map.put("nextRunDate10", nextRunDate10 != null ? nextRunDate10.toString() : "N/A");
            map.put("nextRunDate20", nextRunDate20 != null ? nextRunDate20.toString() : "N/A");
            map.put("nextRunDate30", nextRunDate30 != null ? nextRunDate30.toString() : "N/A");
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom, @QueryParam(value="dailyCronExpression") String dailyCronExpression) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        DAO.updateDailyCronExpression(dailyCronExpression);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            IUMWatcherJob.getInstance().injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMWatcherJobData(), IUMWatcherJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobWatchRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            IUMWatcherJob.getInstance().injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobWatchRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobWatchRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobWatchRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobWatchRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ConfluenceUser currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ConfluenceUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobWatchRestController.localThread.isWorking = true;
                IUMWatcherJob.getInstance().injectService(JobWatchRestController.this.helperTrialProcessing, JobWatchRestController.this.helperService, JobWatchRestController.this.iumHelperCacheService, JobWatchRestController.this.jobResultRepository);
                List<ProcessResult> processResultList = IUMWatcherJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                JobWatchRestController.localThread.processResultList = processResultList;
                JobWatchRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobWatchRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobWatchRestController.localThread.isWorking = false;
            }
        }
    }
}

